/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.HypermediaPagingProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;

import com.squareup.javapoet.CodeBlock;

public class SdkHypermediaPaginationOperation extends AbstractSdkPaginationOperation {

  public SdkHypermediaPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                          ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  public CodeBlock getPagingMethodOperation() {
    CodeBlock.Builder paginationBody = CodeBlock.builder();
    paginationBody.addStatement(
                                "return new $T($S, requestFactory, getExpressionLanguage(), streamingHelper, $S, resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis())",
                                getPagingProviderClass(),
                                getPagination().getNextUrlExpression(),
                                getPagination().getPaginationResponseExpression());
    return paginationBody.build();
  }

  @Override
  public Class<?> getPagingProviderClass() {
    return HypermediaPagingProvider.class;
  }

}
