/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.TRIGGER;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataDefinition.SAMPLE_DATA_SUFFIX;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReference;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;

import com.squareup.javapoet.TypeName;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SdkSampleDataReference extends AbstractSdkResolverProviderReference {

  private final SdkConnector sdkConnector;

  private final ResolverReference<SampleDataDefinition> reference;
  private final SdkSampleDataDefinition sdkResolverDefinition;
  private final List<SdkParameter> sdkParameters;
  private final String parentClassName;

  public SdkSampleDataReference(Path outputDir,
                                ConnectorModel connectorModel,
                                SdkConnector sdkConnector,
                                String parentClassName,
                                List<SdkParameter> sdkParameters,
                                ResolverReference<SampleDataDefinition> reference,
                                SdkSampleDataDefinition sdkResolverDefinition,
                                RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, reference, sdkResolverDefinition, runConfiguration, false);
    this.sdkConnector = sdkConnector;
    this.reference = reference;
    this.sdkResolverDefinition = sdkResolverDefinition;
    this.sdkParameters = sdkParameters;
    this.parentClassName = parentClassName;
  }

  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.sample";
  }

  public String getJavaClassName() {
    return parentClassName + SAMPLE_DATA_SUFFIX;
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkParameters;
  }

  @Override
  protected List<BindingField> getBindingFields() {
    final String searchParam = ParameterType.BODY.getAccessorName() + ".";

    return reference.getArguments().stream()
        .filter(x -> x.getValue().getValue().contains(searchParam))
        .map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, "")))
        .collect(Collectors.toList());
  }

  @Override
  protected String getEvaluationContextKind() {
    return sdkResolverDefinition.getEvaluationContextKind();
  }

  @Override
  protected Map<String, TypeName> getAllParents() {
    return sdkConnector.getParentSampleDataProviders();
  }

  @Override
  protected boolean isBoundParameter(SdkParameter sdkParameter) {
    if (sdkParameter.getParameterType().equals(TRIGGER)) {
      return true;
    }

    return super.isBoundParameter(sdkParameter);
  }

  @Override
  protected AbstractSdkResolverProviderReferenceParent getNewParent(boolean useExtensionsApi) {
    return new SdkSampleDataReferenceParent(outputDir,
                                            connectorModel,
                                            reference,
                                            sdkResolverDefinition,
                                            sdkParameters,
                                            runConfiguration);
  }
}
