/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkPaginationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public abstract class AbstractSdkPaginationOperation
extends AbstractSdkOperation
implements SdkPaginationStrategy {
    private final Pagination pagination;

    public AbstractSdkPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        this.pagination = operation.getPagination();
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @Override
    public CodeBlock getPagingMethodOperation() throws TemplatingException {
        return CodeBlock.builder().addStatement("return new $T($S, $L, requestFactory, getExpressionLanguage(), streamingHelper, $S, resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis())", new Object[]{this.getPagingProviderClass(), this.pagination.getPaginationParameter(), this.getPagingParameter().getJavaName(), this.getPayloadExpression()}).build();
    }

    protected SdkParameter getPagingParameter() throws TemplatingException {
        return this.allQueryParameters.stream().filter(x -> x.getExternalName().equalsIgnoreCase(this.pagination.getPaginationParameter())).findFirst().orElseThrow(() -> new TemplatingException("Could not get paging parameter, this is a bug."));
    }

    @Override
    public TypeName generateMethodReturn() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(PagingProvider.class), (TypeName[])new TypeName[]{TypeName.get(RestConnection.class), ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{String.class})});
    }

    @Override
    protected AbstractSdkOperation.MessageOutputType getMessageOutputType() {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        TypeName attribute = TypeName.get(Void.class);
        return new AbstractSdkOperation.MessageOutputType((TypeName)parameterizedTypeName, attribute);
    }

    @Override
    public CodeBlock generateOperationMethodBody(List<ParameterSpec> parameters) throws TemplatingException {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        CodeBlock.Builder requestMethodBodyBuilder = super.generateCommonOperationMethodBody(parameters);
        requestMethodBodyBuilder.addStatement("return builder", new Object[0]);
        paginationBody.add("$T<$T,$T> requestFactory = connection -> { $L }; ", new Object[]{Function.class, RestConnection.class, RestRequestBuilder.class, requestMethodBodyBuilder.build()});
        paginationBody.add(this.getPagingMethodOperation());
        return paginationBody.build();
    }

    @Override
    public String getPayloadExpression() {
        return this.pagination.getPaginationResponseExpression();
    }

    @Override
    protected boolean requiresConnectionParameter() {
        return false;
    }

    @Override
    protected boolean requiresCallbackParameter() {
        return false;
    }

    @Override
    protected boolean requiresMediaTypeAnnotation() {
        return false;
    }
}

