/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers;

import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output.SdkHttpResponseAttributesMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkTriggerOutputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataFactory;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.AbstractSdkTriggerLayer;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class SdkTriggerImplementationLayer
extends AbstractSdkTriggerLayer {
    private final TypeName superclass;
    private final SdkTriggerOutputMetadataResolver outputMetadataResolver;
    private final List<SdkParameter> sdkParameters;
    private AbstractSdkResolverProvider sdkSampleDataProvider;

    public SdkTriggerImplementationLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, String javaClassName, String packageName, TypeName superclass, List<SdkParameter> sdkParameters, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, trigger, javaClassName, packageName, runConfiguration);
        this.superclass = superclass;
        this.outputMetadataResolver = this.buildOutputMetadataResolver(outputDir, connectorModel, sdkConnector, trigger, runConfiguration);
        this.sdkParameters = sdkParameters;
    }

    private SdkTriggerOutputMetadataResolver buildOutputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        return new SdkTriggerOutputMetadataResolver(outputDir, connectorModel, sdkConnector, trigger.getInternalName(), trigger.getTriggerOutputType(), trigger.getName(), runConfiguration);
    }

    private void generateTriggerClass() throws TemplatingException {
        TypeSpec.Builder triggerClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass).addAnnotation(this.generateMediaTypeAnnotation()).addAnnotation(this.generateDisplayNameAnnotation());
        this.sdkSampleDataProvider = this.buildSampleData();
        if (this.sdkSampleDataProvider != null) {
            this.addSampleDataAnnotation(triggerClassBuilder);
        }
        triggerClassBuilder.addAnnotation(this.getMetadataScopeAnnotation());
        if (this.trigger.isSidecar()) {
            triggerClassBuilder.addAnnotation(this.generateSidecarAnnotation());
        }
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(triggerClassBuilder.build(), this.getPackage());
        this.writeJavaFile(javaFileBuilder.build());
    }

    private AnnotationSpec generateMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.trigger.getTriggerOutputType().getMediaType()}).build();
    }

    private AnnotationSpec getMetadataScopeAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(MetadataScope.class);
        if (this.outputMetadataResolver != null && this.outputMetadataResolver.getRequiresMetadataResolver()) {
            builder.addMember("outputResolver", "$T.class", new Object[]{ClassName.get((String)this.outputMetadataResolver.getPackage(), (String)this.outputMetadataResolver.getClassName(), (String[])new String[0])});
        }
        return builder.addMember("attributesResolver", "$T.class", new Object[]{ClassName.get(SdkHttpResponseAttributesMetadataResolver.class)}).build();
    }

    private AnnotationSpec generateSidecarAnnotation() {
        return AnnotationSpec.builder(Ignore.class).build();
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.trigger.getDisplayName()}).build();
    }

    private AbstractSdkResolverProvider buildSampleData() {
        return SdkSampleDataFactory.getSdkSampleDataResolver(this.trigger, this.connectorModel, this.sdkConnector, this.getJavaClassName(), this.sdkParameters, this.outputDir, this.runConfiguration);
    }

    private void addSampleDataAnnotation(TypeSpec.Builder triggerClassBuilder) {
        if (this.sdkSampleDataProvider != null) {
            AnnotationSpec sampleDataAnnotation = AnnotationSpec.builder(SampleData.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.sdkSampleDataProvider.getPackage(), (String)this.sdkSampleDataProvider.getJavaClassName(), (String[])new String[0])}).build();
            triggerClassBuilder.addAnnotation(sampleDataAnnotation);
        }
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateTriggerClass();
        if (this.outputMetadataResolver != null) {
            this.outputMetadataResolver.applyTemplates();
        }
        if (this.sdkSampleDataProvider != null) {
            this.sdkSampleDataProvider.applyTemplates();
        }
    }
}

