/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;

public class TypeDefinitionUtil {
    private TypeDefinitionUtil() {
    }

    public static Type getJavaType(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return TypeDefinitionUtil.getJavaPrimitiveType((PrimitiveTypeDefinition)typeDefinition);
        }
        return InputStream.class;
    }

    private static Type getJavaPrimitiveType(PrimitiveTypeDefinition primitiveTypeDefinition) {
        switch (primitiveTypeDefinition.getPrimitiveType()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case NUMBER: {
                return Double.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: 
            case TIME_ONLY: {
                return Date.class;
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTime.class;
            }
            case ZONED_DATE_TIME: {
                return ZonedDateTime.class;
            }
            case FILE: 
            case BINARY: {
                return InputStream.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("PrimitiveTypeDefinition not supported : " + primitiveTypeDefinition.getPrimitiveType());
    }
}

