/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.OffsetPagingProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.squareup.javapoet.ParameterSpec;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;


public class SdkOffsetPaginationOperation extends AbstractSdkPaginationOperation {

  public SdkOffsetPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                      ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  protected List<ParameterSpec> getPagingParametersAsParameterSpecs() throws TemplatingException {
    List<ParameterSpec> parameterSpecs = new ArrayList<>();
    ParameterSpec parameterSpecBuilder1 = getPagingParameter().generateParameterParameter(false).build();
    parameterSpecs.add(parameterSpecBuilder1);
    return parameterSpecs;
  }

  @Override
  public Class<?> getPagingProviderClass() {
    return OffsetPagingProvider.class;
  }

  public String getPaginationParameterName() {
    return getPagination().getPaginationParameter();
  }
}
