/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import static com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderFactory.generateSdkValueProvider;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;

import java.nio.file.Path;

public class SdkField extends JavaTemplateEntity {

  private final Field field;
  private final SdkConnector connector;
  private final JavaTemplateEntity parentElement;
  private final SdkResolverTemplate sdkValueProvider;

  public SdkField(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                  Field field, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);
    this.field = field;
    this.connector = sdkConnector;
    this.parentElement = parentElement;
    sdkValueProvider = generateSdkValueProvider(field.getValueProvider(), (SdkOperation) parentElement, field.getPath(),
                                                outputDir, connectorModel, connector, runConfiguration, false, false);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    sdkValueProvider.applyTemplates();
  }

  public Field getField() {
    return field;
  }

  public String getExternalName() {
    return field.getPath();
  }

  public SdkResolverTemplate getSdkValueProvider() {
    return sdkValueProvider;
  }

}
