/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.SdkConfig;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkOutputAttributesMetadataResolver;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;

public class SdkConnector
extends JavaTemplateEntity {
    private final List<SdkConfig> configs;
    private final Map<TypeSchema, String> typeSchemaNames = new HashMap<TypeSchema, String>();
    private final Map<String, TypeName> parentValueProviders = new HashMap<String, TypeName>();
    private final Map<String, TypeName> parentSampleDataProviders = new HashMap<String, TypeName>();
    private String className;
    private String javaPackage;
    private SdkOutputAttributesMetadataResolver outputAttributesResolver;
    public static final String API_METADATA_CATEGORY = "API_METADATA_CATEGORY";

    public SdkConnector(Path outputDir, ConnectorModel connectorModel, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.initialize(connectorModel);
        this.outputAttributesResolver = new SdkOutputAttributesMetadataResolver(outputDir, connectorModel, this, runConfiguration);
        this.configs = Stream.of(new SdkConfig(outputDir, connectorModel, this, runConfiguration)).collect(Collectors.toList());
    }

    private void initialize(ConnectorModel connectorModel) {
        this.className = JavaUtils.getJavaUpperCamelNameFromXml((String)connectorModel.getConnectorXmlName());
        this.javaPackage = connectorModel.getBasePackage() + ".internal.extension";
    }

    public String getJavaName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.connectorModel.getConnectorXmlName());
    }

    private Category getCategory() {
        return this.connectorModel.getCategory() != null ? Category.valueOf((String)this.connectorModel.getCategory().getCategoryName().toUpperCase()) : null;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConnectorClass();
        this.outputAttributesResolver.applyTemplates();
        for (SdkConfig config : this.configs) {
            config.applyTemplates();
        }
    }

    private void generateConnectorClass() throws TemplatingException {
        TypeSpec.Builder connectorClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.getExtensionAnnotation()).addAnnotation(this.getXmlAnnotation()).addAnnotation(this.getConfigurationsAnnotation()).addAnnotation(this.getErrorTypesAnnotation());
        if (!Category.COMMUNITY.equals((Object)this.getCategory())) {
            connectorClassBuilder.addAnnotation(this.getLicenseAnnotation());
        }
        connectorClassBuilder.addField(SdkConnector.getConstantStringField(API_METADATA_CATEGORY, this.connectorModel.getConnectorName(), Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL));
        this.writeClassToFile(connectorClassBuilder.build(), this.javaPackage);
    }

    public TypeName getTypeName() {
        return ClassName.get((String)this.javaPackage, (String)this.className, (String[])new String[0]);
    }

    public TypeName getOutputAttributesResolver() {
        return this.outputAttributesResolver.getTypeName();
    }

    private AnnotationSpec getExtensionAnnotation() {
        String extensionName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, this.connectorModel.getConnectorXmlName());
        extensionName = ParserUtils.splitCaps((String)extensionName, (String)" ");
        AnnotationSpec.Builder extensionAnnotationBuilder = AnnotationSpec.builder(Extension.class).addMember("name", "$S", new Object[]{extensionName});
        if (this.getCategory() != null) {
            extensionAnnotationBuilder.addMember("category", "$T.$L", new Object[]{Category.class, this.getCategory()});
        }
        return extensionAnnotationBuilder.build();
    }

    private AnnotationSpec getLicenseAnnotation() {
        AnnotationSpec.Builder connectorAnnotationBuilder = AnnotationSpec.builder(RequiresEnterpriseLicense.class).addMember("allowEvaluationLicense", "$L", new Object[]{true});
        return connectorAnnotationBuilder.build();
    }

    private AnnotationSpec getXmlAnnotation() {
        AnnotationSpec.Builder connectorAnnotationBuilder = AnnotationSpec.builder(Xml.class).addMember("prefix", "$S", new Object[]{this.connectorModel.getExtensionXml()});
        return connectorAnnotationBuilder.build();
    }

    private AnnotationSpec getConfigurationsAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.configs.size(); ++i) {
            SdkConfig config = this.configs.get(i);
            codeBlock.add("$T.class", new Object[]{config.getTypeName()});
            if (i >= this.configs.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder configurationsAnnotationBuilder = AnnotationSpec.builder(Configurations.class).addMember("value", codeBlock.build());
        return configurationsAnnotationBuilder.build();
    }

    private AnnotationSpec getErrorTypesAnnotation() {
        return AnnotationSpec.builder(ErrorTypes.class).addMember("value", "$T.class", new Object[]{RestError.class}).build();
    }

    public Map<TypeSchema, String> getTypeSchemaNames() {
        return this.typeSchemaNames;
    }

    public Map<String, TypeName> getParentValueProviders() {
        return this.parentValueProviders;
    }

    public Map<String, TypeName> getParentSampleDataProviders() {
        return this.parentSampleDataProviders;
    }
}

