/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SdkResolverUtil {
    public static String getBindingMethod(ParameterType parameterType) {
        switch (parameterType) {
            case URI: 
            case QUERY: 
            case HEADER: {
                return parameterType.getAccessorName();
            }
        }
        throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
    }

    public static boolean isBoundParameterForHttpBinding(SdkParameter sdkParameter, HttpRequestBinding httpBinding) {
        List expressions;
        if (httpBinding == null) {
            return false;
        }
        switch (sdkParameter.getParameterType()) {
            case URI: {
                expressions = httpBinding.getUriParameterExpressions();
                break;
            }
            case QUERY: {
                expressions = httpBinding.getQueryParameterExpressions();
                break;
            }
            case HEADER: {
                expressions = httpBinding.getHeaderExpressions();
                break;
            }
            case AUXILIAR: 
            case TRIGGER: {
                expressions = httpBinding.getAllExpressions();
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type '" + sdkParameter.getParameterType() + "' not supported. This is a bug.");
            }
        }
        return expressions.stream().anyMatch(x -> SdkResolverUtil.isBoundScript(sdkParameter, x.getValue()));
    }

    public static boolean isBoundScript(SdkParameter sdkParameter, String script) {
        if (script == null) {
            return false;
        }
        String bindingName = sdkParameter.getParameterType().getBinding();
        String[] accessors = DataWeaveExpressionParser.selectionsFromBinding((String)script, (String)bindingName);
        return Arrays.asList(accessors).contains(sdkParameter.getExternalName());
    }

    public static List<BindingField> getBodyFieldsFromHttpBinding(HttpRequestBinding httpBinding) {
        if (httpBinding == null) {
            return Collections.emptyList();
        }
        String searchParam = ParameterType.BODY.getBinding() + ".";
        ArrayList parameterBindings = new ArrayList();
        parameterBindings.addAll(httpBinding.getUriParameter());
        parameterBindings.addAll(httpBinding.getQueryParameter());
        parameterBindings.addAll(httpBinding.getHeader());
        return parameterBindings.stream().filter(x -> x.getValue().getValue().contains(searchParam)).map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, ""))).collect(Collectors.toList());
    }

    public static String getActingParameterJavaName(Argument argument) {
        return JavaUtils.getParameterJavaName((String)XmlUtils.getXmlName((String)argument.getName()), (boolean)false);
    }
}

