/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.AbstractSdkTriggerLayer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.file.Path;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;

public class SdkTriggerBaseLayer
extends AbstractSdkTriggerLayer {
    private static final String PATH_TEMPLATE_FIELD = "PATH_TEMPLATE";
    private static final String ITEMS_EXPRESSION_FIELD = "ITEMS_EXPRESSION";
    private static final String WATERMARK_EXPRESSION_FIELD = "WATERMARK_EXPRESSION";
    private static final String IDENTITY_EXPRESSION_FIELD = "IDENTITY_EXPRESSION";
    private static final String REQUEST_BODY_EXPRESSION_FIELD = "REQUEST_BODY_EXPRESSION";
    private static final String EVENT_EXPRESSION_FIELD = "EVENT_EXPRESSION";
    private static final String START_VALUE_FIELD = "START_VALUE_EXPRESSION";
    private static final String WATERMARK_DATA_TYPE_METHOD = "getWatermarkDataType";
    private static final String GET_PATH_TEMPLATE_METHOD = "getPathTemplate";
    private static final String GET_REQUEST_BUILDER_METHOD = "getRequestBuilder";
    private static final String GET_PARAMETER_BINDING_METHOD = "getParameterBinding";
    private static final String GET_PARAMETER_VALUES_METHOD = "getParameterValues";
    private static final String GET_CUSTOM_PARAMETER_VALUES_METHOD = "getCustomParameterValues";
    private static final String GET_REQUEST_BODY_DATA_TYPE_METHOD = "getRequestBodyDataType";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "parameterBinding";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String PARAMETER_VALUES_LOCAL_VARIABLE = "parameterValues";
    private static final String GET_TYPED_VALUE_OR_NULL_METHOD = "getTypedValueOrNull";
    private final TypeName superclass;
    private final List<SdkParameter> sdkParameters;

    public SdkTriggerBaseLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, List<SdkParameter> sdkParameters, String javaClassName, String packageName, TypeName superclass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, sdkConnector, trigger, javaClassName, packageName, runConfiguration);
        this.superclass = superclass;
        this.sdkParameters = sdkParameters;
    }

    private MethodSpec generateConstructor() {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addStatement("super($L, $L, $L, $L, $L, $L)", new Object[]{ITEMS_EXPRESSION_FIELD, WATERMARK_EXPRESSION_FIELD, IDENTITY_EXPRESSION_FIELD, REQUEST_BODY_EXPRESSION_FIELD, EVENT_EXPRESSION_FIELD, START_VALUE_FIELD});
        return constructorBuilder.build();
    }

    private void generateTriggerClass() throws TemplatingException {
        TypeSpec.Builder triggerClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass).addMethod(this.generateConstructor()).addMethod(this.generateWatermarkDataTypeMethod()).addMethod(this.generateGetPathTemplateMethod()).addMethod(this.generateGetRequestBuilderMethod()).addMethod(this.generateGetParameterBindingMethod()).addMethod(this.generateGetParameterValuesMethod()).addMethod(this.generateGetCustomParameterValuesMethod()).addMethod(this.generateGetRequestBodyDataTypeMethod());
        this.addClassConstants(triggerClassBuilder);
        this.addParameters(triggerClassBuilder);
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(triggerClassBuilder.build(), this.getPackage());
        javaFileBuilder.addStaticImport(RestSdkUtils.class, new String[]{GET_TYPED_VALUE_OR_NULL_METHOD});
        this.writeJavaFile(javaFileBuilder.build());
    }

    @Override
    public String getJavaClassName() {
        return super.getJavaClassName() + "Base";
    }

    @Override
    public String getPackage() {
        return super.getPackage() + ".base";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateTriggerClass();
    }

    private MethodSpec generateGetRequestBodyDataTypeMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BODY_DATA_TYPE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return \"$L\"", new Object[]{this.getRequestBodyDataType()});
        return methodBuilder.build();
    }

    private String getRequestBodyDataType() {
        TypeDefinition inputMetadata = this.trigger.getOperation().getInputMetadata();
        if (inputMetadata == null || inputMetadata.getMediaType() == null) {
            return MediaType.APPLICATION_JSON.toString();
        }
        if (inputMetadata.getMediaType().isCompatible(javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE)) {
            return MediaType.APPLICATION_JSON.toString();
        }
        if (inputMetadata.getMediaType().isCompatible(javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE)) {
            return MediaType.APPLICATION_XML.toString();
        }
        if (inputMetadata.getMediaType().isCompatible(javax.ws.rs.core.MediaType.TEXT_PLAIN_TYPE)) {
            return MediaType.TEXT.toString();
        }
        return MediaType.APPLICATION_JSON.toString();
    }

    private void addParameters(TypeSpec.Builder triggerClassBuilder) {
        for (SdkParameter sdkParameter : this.sdkParameters) {
            triggerClassBuilder.addField(sdkParameter.generateParameterField().build());
        }
    }

    private void addClassConstants(TypeSpec.Builder triggerClassBuilder) {
        triggerClassBuilder.addField(SdkTriggerBaseLayer.getConstantStringField(PATH_TEMPLATE_FIELD, this.trigger.getOperation().getPath())).addField(SdkTriggerBaseLayer.getConstantStringField(ITEMS_EXPRESSION_FIELD, this.trigger.getItemsExpression())).addField(SdkTriggerBaseLayer.getConstantStringField(WATERMARK_EXPRESSION_FIELD, this.trigger.getWatermarkExpression())).addField(SdkTriggerBaseLayer.getConstantStringField(IDENTITY_EXPRESSION_FIELD, this.trigger.getIdentityExpression())).addField(SdkTriggerBaseLayer.getConstantStringField(REQUEST_BODY_EXPRESSION_FIELD, this.trigger.getRequestBodyExpression())).addField(SdkTriggerBaseLayer.getConstantStringField(EVENT_EXPRESSION_FIELD, this.trigger.getEventExpression())).addField(SdkTriggerBaseLayer.getConstantStringField(START_VALUE_FIELD, this.trigger.getStartValueExpression()));
    }

    private MethodSpec generateWatermarkDataTypeMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)WATERMARK_DATA_TYPE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(DataType.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $T.fromType($T.class)", new Object[]{DataType.class, this.getJavaType(this.trigger.getWatermarkType())});
        return methodBuilder.build();
    }

    private MethodSpec generateGetPathTemplateMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PATH_TEMPLATE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $L", new Object[]{PATH_TEMPLATE_FIELD});
        return methodBuilder.build();
    }

    private MethodSpec generateGetRequestBuilderMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BUILDER_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RestRequestBuilder.class).addAnnotation(Override.class).addParameter(String.class, "path", new Modifier[0]);
        methodBuilder.addStatement("$1T builder = new $1T(connection.getBaseUri(), path, $2T.$3L)", new Object[]{RestRequestBuilder.class, HttpConstants.Method.class, this.trigger.getOperation().getHttpMethod().name().toUpperCase()});
        if (this.connectorModel.getInterceptors() != null && this.connectorModel.getInterceptors().size() > 0) {
            methodBuilder.addStatement("builder.responseInterceptorDescriptor(config.getResponseInterceptorDescriptor())", new Object[0]);
        }
        methodBuilder.addStatement("return builder", new Object[0]);
        return methodBuilder.build();
    }

    private MethodSpec generateGetParameterBindingMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_BINDING_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(HttpRequestBinding.class).addAnnotation(Override.class);
        methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{HttpRequestBinding.class, PARAMETER_BINDING_LOCAL_VARIABLE});
        if (this.trigger.getParameterBindings() != null) {
            for (ParameterBinding binding : this.trigger.getParameterBindings()) {
                methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, this.getParameterBindingAddMethodName(binding), binding.getName(), binding.getExpression()});
            }
        }
        methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private String getParameterBindingAddMethodName(ParameterBinding binding) {
        switch (binding.getParameterType()) {
            case QUERY: {
                return ADD_QUERY_BINDING_METHOD;
            }
            case HEADER: {
                return ADD_HEADER_BINDING_METHOD;
            }
            case URI: {
                return ADD_URI_BINDING_METHOD;
            }
        }
        throw new IllegalArgumentException(String.format("Parameter type '%s' not supported. This is a bug.", binding.getParameterType()));
    }

    private MethodSpec generateGetParameterValuesMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_VALUES_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.getParameterValuesMultiMapType()).addAnnotation(Override.class);
        methodBuilder.addStatement("final $T $L = new $T<>()", new Object[]{this.getParameterValuesMultiMapType(), PARAMETER_VALUES_LOCAL_VARIABLE, MultiMap.class});
        for (SdkParameter sdkParameter : this.sdkParameters) {
            methodBuilder.addStatement("$L.put($S, $L($L))", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE, sdkParameter.getExternalName(), GET_TYPED_VALUE_OR_NULL_METHOD, sdkParameter.getJavaName()});
        }
        methodBuilder.addStatement("return $L", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private MethodSpec generateGetCustomParameterValuesMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_CUSTOM_PARAMETER_VALUES_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.getParameterValuesMultiMapType()).addAnnotation(Override.class);
        methodBuilder.addStatement("final $T $L = new $T<>()", new Object[]{this.getParameterValuesMultiMapType(), PARAMETER_VALUES_LOCAL_VARIABLE, MultiMap.class});
        methodBuilder.addComment("Add custom parameters here", new Object[0]);
        methodBuilder.addStatement("return $L", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private ParameterizedTypeName getParameterValuesMultiMapType() {
        ParameterizedTypeName wildcardTypedValueType = ParameterizedTypeName.get((ClassName)ClassName.get(TypedValue.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        return ParameterizedTypeName.get((ClassName)ClassName.get(MultiMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), wildcardTypedValueType});
    }
}

