/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.MarkerPagingProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;
import java.util.List;

import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.CodeBlock;

import static java.util.stream.Collectors.toList;

public class SdkMarkerPaginationOperation extends AbstractSdkPaginationOperation {

  public SdkMarkerPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                      ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  public CodeBlock getPagingMethodOperation() {
    CodeBlock.Builder paginationBody = CodeBlock.builder();
    paginationBody.add(
                       "return new $T($S, $S, requestFactory, $L, $S, "
                           + "resolveDefaultResponseMediaType(config), $L, $L,  overrides.getResponseTimeoutAsMillis())",
                       getPagingProviderClass(),
                       getPagination().getPaginationParameter(),
                       getPagination().getNextTokenExpression(),
                       EXPRESSION_LANGUAGE,
                       getPagination().getPaginationResponseExpression(),
                       PARAMETER_BINDINGS_NAME,
                       CUSTOM_PARAMETER_BINDINGS_NAME);

    addResponseBindings(paginationBody);
    return paginationBody.build();
  }

  @Override
  protected List<SdkParameter> generateQueryParameters() {
    return allQueryParameters.stream()
        .filter(param -> !this.getPagination().getPaginationParameter().equals(param.getExternalName()))
        .collect(toList());
  }

  @Override
  protected boolean externalizePagingParam() {
    return false;
  }

  @Override
  public Class<?> getPagingProviderClass() {
    return MarkerPagingProvider.class;
  }

}
