/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationKind;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkHypermediaPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkMarkerPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkMultipartOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkNativeOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOffsetPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkPageNumberPaginationOperation;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;

public class SdkOperationFactory {
    public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        if (operation.hasPagination()) {
            PaginationKind pagingType = operation.getPagination().getKind();
            if (pagingType.equals(PaginationKind.OFFSET)) {
                return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals(PaginationKind.MARKER)) {
                return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals(PaginationKind.PAGE_NUMBER)) {
                return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals(PaginationKind.HYPERMEDIA)) {
                return new SdkHypermediaPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
        }
        if (!operation.isRequestBodyBound() && operation.getInputMetadata() instanceof MultipartTypeDefinition) {
            return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        }
        if (StringUtils.isNotBlank((CharSequence)operation.getFqn())) {
            return new SdkNativeOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        }
        return new SdkOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
    }
}

