/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.extension.api.util.NameUtils;

public class ContentNameGenerator {
    public static String getContentName(ConnectorOperation operation, SdkMetadataResolver metadataResolver, SdkContent.SdkContentKind contentType, String partIdentifier) {
        StringBuilder xmlTypeName = new StringBuilder();
        switch (contentType) {
            case INPUT_METADATA: {
                if (operation.getBody() == null) {
                    throw new IllegalArgumentException("Doesn't make sense to have an input operation with a null body, seems like a bug.");
                }
                String bodyIdentifier = operation.getBody().getBodyIdentifier();
                xmlTypeName.append(XmlUtils.getXmlName((String)bodyIdentifier));
                break;
            }
            case PART: {
                xmlTypeName.append(XmlUtils.getXmlName((String)partIdentifier));
            }
        }
        String javaContentName = JavaUtils.getJavaLowerCamelNameFromXml((String)xmlTypeName.toString());
        return ContentNameGenerator.pluralizeBySchema(javaContentName, metadataResolver);
    }

    private static String pluralizeBySchema(String javaContentName, SdkMetadataResolver metadataResolver) {
        JsonTypeLoader jsonTypeLoader;
        Optional metadataType;
        String result = javaContentName;
        String schemaName = metadataResolver.getSchemaName();
        if (StringUtils.isNotBlank((CharSequence)schemaName) && schemaName.endsWith(".json") && (metadataType = (jsonTypeLoader = new JsonTypeLoader(metadataResolver.getTypeDefinition().getTypeSchema().getRawSchema())).load(null)).isPresent() && metadataType.get() instanceof ArrayType) {
            result = NameUtils.pluralize((String)javaContentName);
        }
        return result;
    }
}

