/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import com.mulesoft.connectivity.rest.sdk.api.DescriptorMode;
import com.mulesoft.connectivity.rest.sdk.api.DescriptorScaffolder;
import com.mulesoft.connectivity.rest.sdk.api.RestSdk;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.templating.api.ConnectorType;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSdkExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestSdkExecutor.class);

    public static void createDescriptor(File apiSpec, String specFormat, File outputDir, String descriptorMode, boolean skipValidation) throws MojoExecutionException {
        try {
            DescriptorScaffolder.scaffoldDescriptor((File)apiSpec, (SpecFormat)SpecFormat.getFromString((String)specFormat), (Path)outputDir.toPath(), (DescriptorMode)DescriptorMode.getFromString((String)descriptorMode), (boolean)skipValidation);
            LOGGER.info("Descriptor written to " + outputDir.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create descriptor.", (Throwable)e);
            throw new MojoExecutionException("Failed to create descriptor.", e);
        }
    }

    public static void createConnector(File apiSpec, File descriptor, String specFormat, File outputDir, boolean skipValidation, boolean dynamicMetadata, boolean forceContentParameter) throws MojoExecutionException {
        try {
            RestSdkRunConfiguration runConfiguration = RestSdkRunConfiguration.builder().skipValidations(skipValidation).useDynamicTypeResolvers(dynamicMetadata).disambiguateContentParameters(!forceContentParameter).build();
            ConnectorModel connectorModel = RestSdk.getConnectorModel((File)descriptor, (File)apiSpec, (SpecFormat)SpecFormat.getFromString((String)specFormat), (String)apiSpec.getParent(), (RestSdkRunConfiguration)runConfiguration);
            RestSdk.generateConnector((ConnectorModel)connectorModel, (ConnectorType)ConnectorType.SDK_CONNECTOR, (Path)outputDir.toPath(), (Path)descriptor.toPath(), (RestSdkRunConfiguration)runConfiguration);
            LOGGER.info("Connector written to " + outputDir.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create conector.", (Throwable)e);
            throw new MojoExecutionException("Failed to create connector.", e);
        }
    }
}

