/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import static com.mulesoft.connectivity.rest.sdk.api.DescriptorScaffolder.scaffoldDescriptor;
import static com.mulesoft.connectivity.rest.sdk.api.RestSdk.generateConnector;
import static com.mulesoft.connectivity.rest.sdk.api.RestSdk.getConnectorModel;
import static com.mulesoft.connectivity.rest.sdk.templating.api.ConnectorType.SDK_CONNECTOR;
import static org.slf4j.LoggerFactory.getLogger;

import com.mulesoft.connectivity.rest.sdk.api.DescriptorMode;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;

public class RestSdkExecutor {

  private final static Logger LOGGER = getLogger(RestSdkExecutor.class);

  public static void createDescriptor(File apiSpec,
                                      String specFormat,
                                      File outputDir,
                                      String descriptorMode,
                                      boolean skipValidation)
      throws MojoExecutionException {

    try {
      scaffoldDescriptor(apiSpec,
                         SpecFormat.getFromString(specFormat),
                         outputDir.toPath(),
                         DescriptorMode.getFromString(descriptorMode),
                         skipValidation);

      LOGGER.info("Descriptor written to " + outputDir.getAbsolutePath());
    } catch (Exception e) {
      LOGGER.error("Failed to create descriptor.", e);
      throw new MojoExecutionException("Failed to create descriptor.", e);
    }
  }

  public static void createConnector(File apiSpec,
                                     File descriptor,
                                     String specFormat,
                                     File outputDir,
                                     boolean skipValidation,
                                     boolean dynamicMetadata,
                                     boolean forceContentParameter)
      throws MojoExecutionException {

    try {
      RestSdkRunConfiguration runConfiguration = RestSdkRunConfiguration.builder()
          .skipValidations(skipValidation)
          .useDynamicTypeResolvers(dynamicMetadata)
          .disambiguateContentParameters(!forceContentParameter)
          .build();

      ConnectorModel connectorModel =
          getConnectorModel(descriptor,
                            apiSpec,
                            SpecFormat.getFromString(specFormat),
                            apiSpec.getParent(),
                            runConfiguration);

      generateConnector(connectorModel,
                        SDK_CONNECTOR,
                        outputDir.toPath(),
                        descriptor.toPath(),
                        runConfiguration);

      LOGGER.info("Connector written to " + outputDir.getAbsolutePath());

    } catch (Exception e) {
      LOGGER.error("Failed to create conector.", e);
      throw new MojoExecutionException("Failed to create connector.", e);
    }
  }

}
