/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class BaseRestSdkMojo extends AbstractMojo {

  @Parameter(property = "apiSpec", required = true)
  protected File apiSpec;

  @Parameter(property = "specFormat", defaultValue = "raml")
  protected String specFormat;

  @Parameter(property = "outputDir", defaultValue = ".")
  protected File outputDir;

  @Parameter(property = "skipValidation", defaultValue = "false")
  protected boolean skipValidation;
}
