/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONParser;

public abstract class BaseRestSdkMojo
extends AbstractMojo {
    public static final String EXCHANGE_JSON_FILE = "exchange.json";
    @Parameter(property="apiSpec", required=true)
    protected File apiSpec;
    @Parameter(property="outputDir", defaultValue=".")
    protected File outputDir;
    @Parameter(property="skipValidation", defaultValue="false")
    protected boolean skipValidation;

    public File getApiSpec(Log log) throws MojoExecutionException {
        File result = this.apiSpec;
        if (this.apiSpec.getName().equals(EXCHANGE_JSON_FILE)) {
            try {
                log.info((CharSequence)String.format("It seems it's an exchange dependency, reading the [%s] file to extract the main api file", this.apiSpec.getAbsolutePath()));
                String content = new String(Files.readAllBytes(Paths.get(result.toPath().toString(), new String[0])));
                Object obj = JSONParser.parseJSON((String)content);
                JSONObject jsonObject = (JSONObject)obj;
                String mainFile = (String)jsonObject.get("main");
                if (StringUtils.isNotBlank((CharSequence)mainFile)) {
                    log.info((CharSequence)String.format("Main file from exchange is [%s]", mainFile));
                    File apiSpecFileFromExchange = new File(result.getParent(), mainFile);
                    log.info((CharSequence)String.format("Calculated api file [%s]", apiSpecFileFromExchange));
                    result = apiSpecFileFromExchange;
                } else {
                    log.info((CharSequence)String.format("The file [%s] wasn't an exchange file after all, defaulting to assuming is an OAS json file (either OAS 2 or 3)", this.apiSpec.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("There has been an error reading the [%s] ", this.apiSpec), (Exception)e);
            }
        }
        return result;
    }
}

