/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import com.mulesoft.connectivity.rest.sdk.mojo.BaseRestSdkMojo;
import com.mulesoft.connectivity.rest.sdk.mojo.RestSdkExecutor;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generateSources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateSourcesConnectorMojo
extends BaseRestSdkMojo {
    public static final String REST_SDK_GENERATED_SCHEMAS = "rest_sdk_generated_schemas";
    private static final String GENERATE_SOURCES_MOJO_PREVIOUS_RUN_PLACEHOLDER = "GENERATE_SOURCES_MOJO_PREVIOUS_RUN_PLACEHOLDER";
    @Parameter(property="descriptor", required=true)
    private List<File> descriptor;
    @Parameter(property="dynamicMetadata")
    private boolean dynamicMetadata;
    @Parameter(property="overrideSourceDir", defaultValue="src/main/override")
    private String overrideSourceDir;
    @Parameter(property="refinementSourceDir", defaultValue="src/main/refinement")
    private String refinementSourceDir;
    @Parameter(property="generatedSourceDir", defaultValue="target/generated-sources")
    private String generatedSourceDir;
    @Parameter(property="generatedResourcesDir", defaultValue="target/generated-resources")
    private String generatedResourcesDir;
    @Parameter(property="ignoredDir", defaultValue="target/ignored")
    private String ignoredDir;
    @Parameter(property="generatedSchemasDir", defaultValue="rest_sdk_generated_schemas")
    private String generatedSchemasDir;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.hasExecutedBefore()) {
            this.getLog().info((CharSequence)"Skipping execution of generateSources because it has already been run.");
            return;
        }
        this.validate();
        RestSdkExecutor.generateConnectorSources(this.getApiSpec(this.getLog()), this.descriptor, this.outputDir, this.skipValidation, this.dynamicMetadata, true, this.generatedSourceDir, this.generatedResourcesDir, this.overrideSourceDir, this.refinementSourceDir, this.ignoredDir, this.generatedSchemasDir);
        this.project.addCompileSourceRoot(this.outputDir.toPath().resolve(this.overrideSourceDir).toFile().getPath());
        this.project.addCompileSourceRoot(this.outputDir.toPath().resolve(this.refinementSourceDir).toFile().getPath());
        this.project.addCompileSourceRoot(this.outputDir.toPath().resolve(this.generatedSourceDir).toFile().getPath());
        Resource resource = new Resource();
        resource.setDirectory(this.outputDir.toPath().resolve(this.generatedResourcesDir).toFile().getPath());
        this.project.addResource(resource);
    }

    protected boolean hasExecutedBefore() {
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(GENERATE_SOURCES_MOJO_PREVIOUS_RUN_PLACEHOLDER)) {
            return true;
        }
        this.getPluginContext().put(GENERATE_SOURCES_MOJO_PREVIOUS_RUN_PLACEHOLDER, GENERATE_SOURCES_MOJO_PREVIOUS_RUN_PLACEHOLDER);
        return false;
    }

    private void validate() throws MojoExecutionException {
        this.validateSchemaFolderNonRepeatable();
    }

    private void validateSchemaFolderNonRepeatable() throws MojoExecutionException {
        for (Resource resource : this.project.getResources()) {
            String directory = resource.getDirectory();
            File file = new File(directory, REST_SDK_GENERATED_SCHEMAS);
            if (!file.exists()) continue;
            throw new MojoExecutionException(String.format("A folder named %s already exists. REST SDK can not generate schemas there. Configure properly the schemas output folder", this.generatedResourcesDir + "/" + REST_SDK_GENERATED_SCHEMAS));
        }
    }
}

