/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import static com.mulesoft.connectivity.rest.sdk.mojo.RestSdkExecutor.createConnector;
import static org.apache.maven.plugins.annotations.LifecyclePhase.GENERATE_SOURCES;

import java.io.File;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name = "createConnector", defaultPhase = GENERATE_SOURCES, requiresProject = false)
public class CreateConnectorMojo extends BaseRestSdkMojo {

  @Parameter(property = "descriptor", required = true)
  private List<File> descriptor;

  @Parameter(property = "dynamicMetadata")
  private boolean dynamicMetadata;

  public void execute() throws MojoExecutionException {
    createConnector(apiSpec, descriptor, specFormat, outputDir, skipValidation, dynamicMetadata);
  }
}
