/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import com.mulesoft.connectivity.rest.sdk.api.DescriptorMode;
import com.mulesoft.connectivity.rest.sdk.api.DescriptorScaffolder;
import com.mulesoft.connectivity.rest.sdk.api.RestSdk;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.templating.api.ConnectorType;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSdkExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestSdkExecutor.class);

    public static void createDescriptor(File apiSpec, String specFormat, File outputDir, String descriptorMode, boolean skipValidation) throws MojoExecutionException {
        try {
            DescriptorScaffolder.scaffoldDescriptor((File)apiSpec, (SpecFormat)(StringUtils.isNotBlank((CharSequence)specFormat) ? SpecFormat.getFromString((String)specFormat) : null), (Path)outputDir.toPath(), (DescriptorMode)DescriptorMode.getFromString((String)descriptorMode), (boolean)skipValidation);
            LOGGER.info("Descriptor written to " + outputDir.getAbsolutePath());
        }
        catch (Exception e) {
            String message = String.format("Failed to create descriptor, message [%s]", e.getMessage());
            LOGGER.debug(message, (Throwable)e);
            throw new MojoExecutionException(message, e);
        }
    }

    public static void createConnector(File apiSpec, List<File> descriptors, String specFormat, File outputDir, boolean skipValidation, boolean dynamicMetadata) throws MojoExecutionException {
        RestSdkExecutor.createConnector(apiSpec, descriptors, specFormat, outputDir, skipValidation, dynamicMetadata, false, "src/main/java", "src/main/resources", null, null);
    }

    public static void createConnector(File apiSpec, List<File> descriptors, String specFormat, File outputDir, boolean skipValidation, boolean dynamicMetadata, boolean regenerateMode, String generatedSourceDir, String generatedResourcesDir, String overrideSourceDir, String ignoredDir) throws MojoExecutionException {
        try {
            RestSdkRunConfiguration runConfiguration = RestSdkRunConfiguration.builder().skipValidations(skipValidation).useDynamicTypeResolvers(dynamicMetadata).generatedSourceDir(generatedSourceDir).generatedResourcesDir(generatedResourcesDir).overrideSourceDir(overrideSourceDir).ignoredDir(ignoredDir).regenerateMode(regenerateMode).build();
            RestSdk restSdk = new RestSdk(apiSpec, apiSpec.getParent(), runConfiguration).format(StringUtils.isNotBlank((CharSequence)specFormat) ? SpecFormat.getFromString((String)specFormat) : null);
            for (File descriptor : descriptors) {
                restSdk.descriptor(descriptor);
            }
            restSdk.generateConnector(ConnectorType.SDK_CONNECTOR, outputDir.toPath(), runConfiguration);
            runConfiguration.messageCollector().messages().forEach(message -> {
                switch (message.getKind()) {
                    case WARNING: {
                        LOGGER.warn(message.getMessage());
                        break;
                    }
                    case ERROR: {
                        LOGGER.error(message.getMessage());
                        break;
                    }
                    case INFO: {
                        LOGGER.info(message.getMessage());
                    }
                }
            });
            LOGGER.info("Connector written to " + outputDir.getAbsolutePath());
        }
        catch (Exception e) {
            String message2 = String.format("Failed to create connector, message [%s]", e.getMessage());
            LOGGER.debug(message2, (Throwable)e);
            throw new MojoExecutionException(message2, e);
        }
    }
}

