/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import com.mulesoft.connectivity.rest.sdk.mojo.BaseRestSdkMojo;
import com.mulesoft.connectivity.rest.sdk.mojo.RestSdkExecutor;
import java.io.File;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generateSources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateSourcesConnectorMojo
extends BaseRestSdkMojo {
    @Parameter(property="descriptor", required=true)
    private List<File> descriptor;
    @Parameter(property="dynamicMetadata")
    private boolean dynamicMetadata;
    @Parameter(property="overrideSourceDir", defaultValue="src/main/override")
    private String overrideSourceDir;
    @Parameter(property="generatedSourceDir", defaultValue="target/generated-sources")
    private String generatedSourceDir;
    @Parameter(property="generatedResourcesDir", defaultValue="target/generated-resources")
    private String generatedResourcesDir;
    @Parameter(property="ignoredDir", defaultValue="target/ignored")
    private String ignoredDir;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        RestSdkExecutor.createConnector(this.apiSpec, this.descriptor, this.specFormat, this.outputDir, this.skipValidation, this.dynamicMetadata, true, this.generatedSourceDir, this.generatedResourcesDir, this.overrideSourceDir, this.ignoredDir);
        this.project.addCompileSourceRoot(this.outputDir.toPath().resolve(this.overrideSourceDir).toFile().getPath());
        this.project.addCompileSourceRoot(this.outputDir.toPath().resolve(this.generatedSourceDir).toFile().getPath());
        Resource resource = new Resource();
        resource.setDirectory(this.outputDir.toPath().resolve(this.generatedResourcesDir).toFile().getPath());
        this.project.addResource(resource);
    }
}

