/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import static com.mulesoft.connectivity.rest.sdk.mojo.RestSdkExecutor.createDescriptor;
import static org.apache.maven.plugins.annotations.LifecyclePhase.GENERATE_SOURCES;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name = "createDescriptor", defaultPhase = GENERATE_SOURCES, requiresProject = false)
public class CreateDescriptorMojo extends BaseRestSdkMojo {

  @Parameter(property = "descriptorMode", defaultValue = "minimal")
  private String descriptorMode;

  public void execute() throws MojoExecutionException {
    createDescriptor(apiSpec, outputDir, descriptorMode, skipValidation);
  }
}
