/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.mojo;

import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.vfs.Vfs;

@Mojo(name="validateConnector", defaultPhase=LifecyclePhase.COMPILE)
public class ValidateConnectorMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="skipValidation", defaultValue="false")
    protected boolean skipValidation;
    private static final String META_INF = "META-INF";
    private static final String MULE_ARTIFACT_JSON = "mule-artifact.json";
    private static final String MULE_ARTIFACT = "mule-artifact";
    private static final String AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR = Paths.get("META-INF", "auto-generated-mule-artifact.json").toString();
    private static final String MULE_ARTIFACT_DESCRIPTOR = Paths.get("META-INF", "mule-artifact", "mule-artifact.json").toString();

    public void execute() throws MojoExecutionException {
        MulePluginModel pluginModel;
        if (this.skipValidation) {
            this.getLog().warn((CharSequence)String.format("Skipping validation, '%s' may be invalid", MULE_ARTIFACT_DESCRIPTOR));
            return;
        }
        String outputDirectory = this.project.getBuild().getOutputDirectory();
        File muleArtifactDescriptorFile = new File(outputDirectory, MULE_ARTIFACT_DESCRIPTOR);
        if (!muleArtifactDescriptorFile.exists()) {
            muleArtifactDescriptorFile = new File(outputDirectory, AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR);
            this.getLog().info((CharSequence)String.format("Using '%s' to validate due to '%s' has not been created yet", AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR, MULE_ARTIFACT_DESCRIPTOR));
        }
        if (!muleArtifactDescriptorFile.exists()) {
            throw new MojoExecutionException(String.format("Descriptor file is not present at '%s' or '%s, it should have been generated by the mule-extensions-maven-plugin. This is probably a bug", MULE_ARTIFACT_DESCRIPTOR, AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR));
        }
        try (FileReader muleArtifactDescriptorFileReader = new FileReader(muleArtifactDescriptorFile);){
            pluginModel = (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(IOUtils.toString((Reader)muleArtifactDescriptorFileReader));
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Failed to validate connector's '%s' descriptor, message [%s]", MULE_ARTIFACT_JSON, e.getMessage()), e);
        }
        List<String> commonsRestSdkPackages = this.discoverCommonsRestSdkPackages();
        List exportedPackages = (List)pluginModel.getClassLoaderModelLoaderDescriptor().getAttributes().get("exportedPackages");
        List commonsRestSdkExportedPackages = exportedPackages.stream().filter(exportedPackage -> commonsRestSdkPackages.contains(exportedPackage)).collect(Collectors.toList());
        if (!commonsRestSdkExportedPackages.isEmpty()) {
            throw new MojoExecutionException(String.format("Connector generated defines exported packages from RSDK commons library: %s", commonsRestSdkExportedPackages));
        }
    }

    private List<String> discoverCommonsRestSdkPackages() throws MojoExecutionException {
        URL url = BaseRestOperation.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            List<String> packages = this.getPackages(url);
            this.getLog().debug((CharSequence)String.format("Packages discovered for URL: %s are: %s", url, packages));
            return packages;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("There was an error while scanning type elements from [%s]", url), (Throwable)e);
            throw new MojoExecutionException("Failed to validate connector's due to packages for RSDK commons library couldn't be discovered", e);
        }
    }

    private List<String> getPackages(URL url) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(new URL[]{url}).setScanners(new Scanner[]{new PackageScanner()}));
        return reflections.getStore().values(PackageScanner.class.getSimpleName()).stream().distinct().sorted().collect(Collectors.toList());
    }

    private class PackageScanner
    extends AbstractScanner {
        private PackageScanner() {
        }

        public boolean acceptsInput(String file) {
            return file.endsWith(".class");
        }

        public Object scan(Vfs.File file, Object classObject, Store store) {
            Object resolvedClassObject = super.scan(file, classObject, store);
            this.put(store, this.getMetadataAdapter().getClassName(resolvedClassObject), new File(file.getRelativePath()).getParent().replace("/", "."));
            return resolvedClassObject;
        }

        public void scan(Object cls, Store store) {
        }
    }
}

