/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import java.util.List;

public abstract class APISecuritySchemeModel {

  protected String name;
  protected APISecuritySchemeType securitySchemeType;
  protected List<APIParameterModel> customQueryParams;
  protected List<APIParameterModel> customHeaders;
  protected String authorizationUri;
  protected String accessTokenUri;
  protected List<String> scopes;

  public String getName() {
    return name;
  }

  public APISecuritySchemeType getSecuritySchemeType() {
    return securitySchemeType;
  }

  public List<APIParameterModel> getCustomQueryParams() {
    return customQueryParams;
  }

  public List<APIParameterModel> getCustomHeaders() {
    return customHeaders;
  }

  public String getAuthorizationUri() {
    return authorizationUri;
  }

  public String getAccessTokenUri() {
    return accessTokenUri;
  }

  public List<String> getScopes() {
    return scopes;
  }
}
