/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.slf4j.LoggerFactory.getLogger;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;

import java.util.List;

import javax.ws.rs.core.MediaType;

import org.slf4j.Logger;

public abstract class APITypeModel {

  private static final Logger LOGGER = getLogger(APITypeModel.class);

  protected APIType apiType;
  protected MediaType mediaType;
  protected String example;
  protected List<String> enumValues;
  protected com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel APITypeSchemaModel;
  protected APIPrimitiveTypeModel primitiveTypeModel;
  protected List<APIParameterModel> parts;
  protected APITypeModel innerType;
  protected List<APITypeModel> unionTypes;
  protected String displayName;
  protected String description;

  protected APITypeModel() {

  }

  protected APITypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
    this.apiType = APIType.PRIMITIVE;
    this.primitiveTypeModel = primitiveTypeModel;
  }

  protected MediaType getMediaTypeForStringOrNull(String mediaType) {
    try {
      return isNotBlank(mediaType) ? MediaType.valueOf(mediaType) : null;
    } catch (Exception e) {
      LOGGER.error("Error getting media type", e);
      return null;
    }
  }

  public APIType getApiType() {
    return apiType;
  }

  public MediaType getMediaType() {
    return mediaType;
  }

  public String getExample() {
    return example;
  }

  public List<String> getEnumValues() {
    return enumValues;
  }

  public APITypeSchemaModel getAPITypeSchemaModel() {
    return APITypeSchemaModel;
  }

  public APIPrimitiveTypeModel getPrimitiveTypeModel() {
    return primitiveTypeModel;
  }

  public List<APIParameterModel> getParts() {
    return parts;
  }

  public APITypeModel getInnerType() {
    return innerType;
  }

  public List<APITypeModel> getUnionTypes() {
    return unionTypes;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getDescription() {
    return description;
  }
}
