/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum SpecFormat {
    RAML("RAML"),
    JSON_OAS("JsonOAS"),
    YAML_OAS("YamlOAS"),
    JSON_OAS3("JsonOAS3"),
    YAML_OAS3("YamlOAS3");

    private final String name;

    private SpecFormat(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SpecFormat getFromString(String formatName) {
        return Arrays.stream(SpecFormat.values()).filter(x -> x.name.equalsIgnoreCase(formatName)).findFirst().orElseThrow(() -> SpecFormat.getException(formatName));
    }

    private static IllegalArgumentException getException(String formatName) {
        String allowedValues = Arrays.stream(SpecFormat.values()).map(SpecFormat::getName).collect(Collectors.joining(", "));
        return new IllegalArgumentException("Spec format '" + formatName + "' is not supported. Allowed values are: " + allowedValues);
    }
}

