/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi;

import static java.util.Arrays.stream;
import static java.util.stream.Collectors.joining;

public enum SpecFormat {
  RAML("RAML"), JSON_OAS("JsonOAS"), YAML_OAS("YamlOAS"), JSON_OAS3("JsonOAS3"), YAML_OAS3("YamlOAS3");

  private final String name;

  SpecFormat(String name) {
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public static SpecFormat getFromString(String formatName) {
    return stream(SpecFormat.values())
        .filter(x -> x.name.equalsIgnoreCase(formatName))
        .findFirst()
        .orElseThrow(() -> getException(formatName));
  }

  private static IllegalArgumentException getException(String formatName) {
    final String allowedValues = stream(values()).map(SpecFormat::getName).collect(joining(", "));

    return new IllegalArgumentException("Spec format '" + formatName + "' is not supported. Allowed values are: "
        + allowedValues);
  }
}
