/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.isXmlSchema;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.SchemaShape;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIJsonTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIXmlTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;

import java.util.function.Supplier;

import javax.ws.rs.core.MediaType;

public class AMFTypeSchemaModel extends APITypeSchemaModel {

  protected AMFTypeSchemaModel(Supplier<String> schemaSupplier, MediaType mediaType) {
    this.schemaSupplier = schemaSupplier;
    this.mediaType = mediaType;
  }

  public static AMFTypeSchemaModel.Builder builder() {
    return new AMFTypeSchemaModel.Builder();
  }

  protected static class Builder {

    public APITypeSchemaModel build(AnyShape shape, MediaType mediaType) {

      if (shape instanceof SchemaShape && ((SchemaShape) shape).raw().nonEmpty()) {
        SchemaShape schemaShape = (SchemaShape) shape;
        Supplier<String> supplier = () -> schemaShape.raw().value();

        if (isXmlSchema(schemaShape.raw().value())) {
          String elementName = schemaShape.annotations().fragmentName().orElse(null);
          String path = schemaShape.location().orElse(null);
          return new AMFXmlTypeSchemaModel(supplier, elementName, path);
        } else {
          return new AMFJsonTypeSchemaModel(supplier);
        }
      }

      else if (APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
        return new AMFJsonTypeSchemaModel(new AMFTypeSchemaSupplier(shape, mediaType));
      }

      else if (APPLICATION_XML_TYPE.isCompatible(mediaType)) {
        return new AMFXmlTypeSchemaModel(new AMFTypeSchemaSupplier(shape, mediaType));
      }

      else {
        return new AMFTypeSchemaModel(new AMFTypeSchemaSupplier(shape, mediaType), mediaType);
      }
    }
  }

  protected static class AMFXmlTypeSchemaModel extends APIXmlTypeSchemaModel {

    public AMFXmlTypeSchemaModel(Supplier<String> schemaSupplier) {
      this(schemaSupplier, null, null);
    }

    public AMFXmlTypeSchemaModel(Supplier<String> schemaSupplier, String elementName, String path) {
      this.mediaType = APPLICATION_XML_TYPE;
      this.schemaSupplier = schemaSupplier;
      this.elementName = elementName;
      this.path = path;
    }
  }

  protected static class AMFJsonTypeSchemaModel extends APIJsonTypeSchemaModel {

    public AMFJsonTypeSchemaModel(Supplier<String> schemaSupplier) {
      this.mediaType = APPLICATION_JSON_TYPE;
      this.schemaSupplier = schemaSupplier;
    }
  }

}
