/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.MessageStyle;
import amf.ProfileName;
import amf.ProfileNames;
import amf.client.AMF;
import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import amf.client.model.StrField;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Server;
import amf.client.model.domain.WebApi;
import amf.client.parse.Oas20Parser;
import amf.client.parse.Oas20YamlParser;
import amf.client.parse.Oas30Parser;
import amf.client.parse.Oas30YamlParser;
import amf.client.parse.Parser;
import amf.client.parse.Raml10Parser;
import amf.client.resolve.Oas20Resolver;
import amf.client.resolve.Oas30Resolver;
import amf.client.resolve.Raml10Resolver;
import amf.client.resource.ResourceLoader;
import amf.client.validate.ValidationReport;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.InvalidSourceException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.resourceloader.AMFExchangeDependencyResourceLoader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class AMFAPIModel
extends APIModel {
    private final SpecFormat specFormat;
    private final WebApi webApi;

    public AMFAPIModel(File apiSpec, String rootDir, SpecFormat specFormat, boolean skipValidations) throws ModelGenerationException {
        this.initializeAMF();
        this.specFormat = specFormat;
        this.webApi = this.getWebApi(this.getParser(specFormat, rootDir), apiSpec.toPath(), skipValidations);
        this.apiName = this.buildApiName();
        this.description = this.buildDescription();
        this.protocols = this.buildProtocols();
        this.apiVersion = this.buildApiVersion();
        this.baseUri = this.buildBaseUri();
        this.operationsModel = this.buildOperationsModel();
    }

    private void initializeAMF() {
        try {
            AMF.init().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Could not register dialect.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Could not register dialect.", e);
        }
    }

    private String buildApiName() {
        return this.webApi.name().value();
    }

    private String buildDescription() {
        return this.webApi.description().nonEmpty() ? this.webApi.description().value() : "";
    }

    private String buildApiVersion() {
        return this.webApi.version() != null ? this.webApi.version().value() : null;
    }

    private String buildBaseUri() {
        String baseUri = null;
        Server server = this.webApi.servers().stream().filter(x -> x.url().nonEmpty()).findFirst().orElse(null);
        if (server != null) {
            baseUri = server.url().value();
        }
        return baseUri;
    }

    private List<String> buildProtocols() {
        return this.webApi.schemes().stream().map(StrField::value).collect(Collectors.toList());
    }

    private List<APIOperationModel> buildOperationsModel() throws ModelGenerationException {
        ArrayList<APIOperationModel> operationsModel = new ArrayList<APIOperationModel>();
        for (EndPoint endPoint : this.webApi.endPoints()) {
            for (Operation operation : endPoint.operations()) {
                operationsModel.add(new AMFOperationModel(endPoint, operation));
            }
        }
        return operationsModel;
    }

    private Parser getParser(SpecFormat format, String rootDir) {
        Environment env = DefaultEnvironment.apply().add((ResourceLoader)new AMFExchangeDependencyResourceLoader(rootDir));
        if (format.equals((Object)SpecFormat.RAML)) {
            return new Raml10Parser(env);
        }
        if (format.equals((Object)SpecFormat.JSON_OAS)) {
            return new Oas20Parser(env);
        }
        if (format.equals((Object)SpecFormat.YAML_OAS)) {
            return new Oas20YamlParser(env);
        }
        if (format.equals((Object)SpecFormat.JSON_OAS3)) {
            return new Oas30Parser(env);
        }
        return new Oas30YamlParser(env);
    }

    private WebApi getWebApi(Parser parser, Path path, boolean skipValidations) throws InvalidSourceException {
        Document ramlDocument;
        if (Files.notExists(path, new LinkOption[0])) {
            throw new InvalidSourceException(String.format("Spec file [%s] does not exist", path.toAbsolutePath()));
        }
        if (this.isRaml08(path.toAbsolutePath())) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        try {
            ramlDocument = this.parseFile(parser, "file://" + path.toAbsolutePath().toString());
            if (!skipValidations) {
                this.validate(ramlDocument, this.specFormat);
            }
            ramlDocument = this.resolve(ramlDocument, this.specFormat);
        }
        catch (Exception e) {
            throw new InvalidSourceException("Invalid Spec: Error in AMF: " + e.getMessage() + ".", e);
        }
        return this.getWebApi(ramlDocument);
    }

    private Document resolve(Document ramlDocument, SpecFormat specFormat) {
        if (specFormat.equals((Object)SpecFormat.RAML)) {
            return (Document)new Raml10Resolver().resolve((BaseUnit)ramlDocument);
        }
        if (specFormat.equals((Object)SpecFormat.JSON_OAS) || specFormat.equals((Object)SpecFormat.YAML_OAS)) {
            return (Document)new Oas20Resolver().resolve((BaseUnit)ramlDocument);
        }
        return (Document)new Oas30Resolver().resolve((BaseUnit)ramlDocument);
    }

    private void validate(Document ramlDocument, SpecFormat specFormat) throws ExecutionException, InterruptedException, InvalidSourceException {
        ValidationReport report = specFormat.equals((Object)SpecFormat.RAML) ? (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.RAML(), (MessageStyle)ProfileNames.AMF().messageStyle()).get() : (specFormat.equals((Object)SpecFormat.JSON_OAS) || specFormat.equals((Object)SpecFormat.YAML_OAS) ? (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.OAS(), (MessageStyle)ProfileNames.AMF().messageStyle()).get() : (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.OAS30(), (MessageStyle)ProfileNames.AMF().messageStyle()).get());
        if (!report.conforms()) {
            throw new InvalidSourceException(report.toString());
        }
    }

    private WebApi getWebApi(Document document) {
        return (WebApi)document.encodes();
    }

    private Document parseFile(Parser parser, String url) {
        return this.handleFuture(parser.parseFileAsync(url));
    }

    private Document handleFuture(CompletableFuture<BaseUnit> f) {
        try {
            return (Document)f.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("An error occurred while parsing the api. Message: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("An error occurred while parsing the api. Message: " + e.getMessage(), e);
        }
    }

    private boolean isRaml08(Path specPath) throws InvalidSourceException {
        String content;
        try {
            content = new String(Files.readAllBytes(specPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InvalidSourceException("Could not load raml file content", e);
        }
        return content.startsWith("#%RAML 0.8");
    }
}

