/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.util;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class XmlUtils {
    private XmlUtils() {
    }

    public static boolean isXmlSchema(String schema) {
        return StringUtils.isNotBlank((CharSequence)schema) && schema.trim().startsWith("<");
    }

    public static String removeMavenArtifactUnwantedCharacters(String artifact) {
        if (artifact == null) {
            return null;
        }
        return artifact.replaceAll("[^a-zA-Z0-9_\\-]", "");
    }

    public static String removeMavenGroupUnwantedCharacters(String group) {
        if (group == null) {
            return null;
        }
        return group.replaceAll("[^a-zA-Z0-9\\._\\-]", "");
    }

    public static String removeMavenVersionUnwantedCharacters(String version) {
        if (version == null) {
            return null;
        }
        return version.replaceAll("[^a-zA-Z0-9\\._\\-]", "");
    }

    private static String splitCapsWithHypens(String name) {
        return ParserUtils.splitCaps(name, "-");
    }

    private static String removeXmlUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9_-]", "");
    }

    public static String getXmlName(@NotNull String name) {
        name = XmlUtils.splitCapsWithHypens(name).toLowerCase();
        while (name.matches(".*[a-zA-Z0-9]+[\\s]+[a-zA-Z0-9]+.*")) {
            name = name.replaceAll("([a-zA-Z0-9])[\\s]+([a-zA-Z0-9])", "$1-$2");
        }
        name = XmlUtils.removeXmlUnwantedCharacters(name);
        if (StringUtils.isEmpty((CharSequence)(name = name.replaceAll("_+", "-")))) {
            return "";
        }
        if (name.toLowerCase().startsWith("xml") || Character.isDigit(name.charAt(0))) {
            name = "_" + name;
        }
        if (name.startsWith("-")) {
            name = name.replaceFirst("-", "");
        }
        if (name.endsWith("-")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

