/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import amf.core.client.platform.model.Annotations;
import org.mulesoft.common.client.lexical.PositionRange;

public class APILocation {

  private final String fileName;
  private final APIPosition start, end;

  public APILocation(String fileName, APIPosition start, APIPosition end) {
    this.fileName = fileName;
    this.start = start;
    this.end = end;
  }

  public static APILocation from(Annotations annotations) {
    PositionRange positionRange = annotations.lexical();
    return new APILocation(annotations.location().orElse(null), APIPosition.from(positionRange.start()),
                           APIPosition.from(positionRange.end()));
  }

  public String getFileName() {
    return fileName;
  }

  public APIPosition getStart() {
    return start;
  }

  public APIPosition getEnd() {
    return end;
  }

  @Override
  public String toString() {
    return fileName + ":" + getStart() + "-" + getEnd();
  }
}
