/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.core.client.platform.model.domain.DataNode;
import amf.core.client.platform.model.domain.Graph;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.Example;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.SchemaShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.MalformedSpecException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeSchemaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFTypeModel
extends APITypeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMFTypeModel.class);
    private AnyShape shape;
    private boolean extractExample;

    public AMFTypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
        super(primitiveTypeModel);
    }

    public AMFTypeModel(AnyShape anyShape, String mediaType, boolean extractExample) {
        this(anyShape, mediaType, null, extractExample);
    }

    public AMFTypeModel(AnyShape anyShape, String mediaType, Boolean required, boolean extractExample) {
        List values;
        this.shape = anyShape;
        this.mediaType = this.getMediaTypeForStringOrNull(mediaType);
        this.extractExample = extractExample;
        if (extractExample) {
            this.example = this.buildResponseExample();
        }
        this.enumValues = !(values = this.shape.values()).isEmpty() ? values.stream().map(AMFTypeModel::getEnumValue).collect(Collectors.toList()) : null;
        this.APITypeSchemaModel = AMFTypeSchemaModel.builder().build(anyShape, this.mediaType);
        this.apiType = this.buildTypeDefinitionClass(this.mediaType);
        this.displayName = this.buildDisplayName();
        this.description = this.buildDescription();
        this.required = required;
    }

    private String buildDescription() {
        return this.shape.description().isNullOrEmpty() ? null : this.shape.description().value();
    }

    private String buildDisplayName() {
        return this.shape.displayName().isNullOrEmpty() ? null : this.shape.displayName().value();
    }

    private APIType buildTypeDefinitionClass(MediaType mediaType) {
        if (this.shape instanceof ScalarShape || this.shape instanceof FileShape) {
            this.primitiveTypeModel = new AMFPrimitiveTypeModel((Shape)this.shape);
            return APIType.PRIMITIVE;
        }
        if (MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)mediaType) && this.shape instanceof NodeShape && !((NodeShape)this.shape).properties().isEmpty()) {
            return APIType.MULTIPART;
        }
        if (this.shape instanceof NodeShape || this.shape instanceof SchemaShape) {
            return APIType.OBJECT_TYPE;
        }
        if (this.shape instanceof UnionShape) {
            return APIType.UNION_TYPE;
        }
        if (this.shape instanceof ArrayShape) {
            return APIType.ARRAY;
        }
        if (!(this.shape.and().isEmpty() && this.shape.or().isEmpty() && this.shape.xone().isEmpty())) {
            return APIType.OBJECT_TYPE;
        }
        return APIType.EMPTY;
    }

    private String buildResponseExample() {
        return this.shape.examples().stream().filter(x -> this.mediaType == null || this.isYamlExample((Example)x) || this.isRamlExample((Example)x)).findFirst().map(value -> value.value().value()).orElse(null);
    }

    private boolean isRamlExample(Example example) {
        return example.mediaType().value() == null;
    }

    private boolean isYamlExample(Example example) {
        return example.mediaType().value() != null && example.mediaType().value().equals(this.mediaType.toString());
    }

    @Override
    public List<APIParameterModel> getParts() {
        if (this.apiType.equals((Object)APIType.MULTIPART)) {
            ArrayList<APIParameterModel> parts = new ArrayList<APIParameterModel>();
            for (PropertyShape s : ((NodeShape)this.shape).properties()) {
                parts.add(new AMFParameterModel(s, APIParameterType.PART));
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public AMFTypeModel getInnerType() {
        if (this.shape instanceof ArrayShape) {
            return this.fromShape(((ArrayShape)this.shape).items());
        }
        return null;
    }

    @Override
    public List<APITypeModel> getUnionTypes() {
        if (this.shape instanceof UnionShape) {
            return ((UnionShape)this.shape).anyOf().stream().map(this::fromShape).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, APITypeModel> getObjectProperties() {
        if (!(this.shape instanceof NodeShape)) {
            return Collections.emptyMap();
        }
        return ((NodeShape)this.shape).properties().stream().collect(Collectors.collectingAndThen(Collectors.toMap(ps -> ps.name().value(), ps -> this.fromShape(ps.range())), Collections::unmodifiableMap));
    }

    private AMFTypeModel fromShape(Shape innerShape) {
        if (innerShape instanceof AnyShape) {
            return new AMFTypeModel((AnyShape)innerShape, null, this.extractExample);
        }
        if (innerShape == null) {
            LOGGER.warn("Shape {} has no inner shape (e.g. an array without item type); treating it as string. At {}.", (Object)this.shape, (Object)APILocation.from(this.shape.annotations()));
        } else {
            LOGGER.warn("Shape {} is not supported (within {}); treating it as string. At {}.", new Object[]{innerShape, this.shape, APILocation.from(innerShape.annotations())});
        }
        return new AMFTypeModel(new AMFPrimitiveTypeModel(APIPrimitiveType.STRING));
    }

    private static String getEnumValue(DataNode x) {
        if (x instanceof ScalarNode) {
            return ((ScalarNode)x).value().value();
        }
        throw new MalformedSpecException("Enum value type (" + x.getClass() + ") not supported", APILocation.from(x.annotations()));
    }

    public Graph graph() {
        return this.shape.graph();
    }

    @Override
    public APILocation getLocation() {
        return APILocation.from(this.shape.annotations());
    }
}

