/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIDocumentationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class APIOperationModel {
    protected String operationId;
    protected String name;
    protected String description;
    protected String summary;
    protected String path;
    protected String httpMethod;
    protected List<String> baseUris;
    protected List<APIParameterModel> uriParamsModel;
    protected List<APIParameterModel> queryParamsModel;
    protected List<APIParameterModel> headersModel;
    protected List<APITypeModel> inputMetadataModel;
    protected List<APITypeModel> outputMetadataModel;
    protected List<APISecuritySchemeModel> securitySchemesModel;
    protected APIDocumentationModel apiDocumentationModel;

    public String getOperationId() {
        return this.operationId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getPath() {
        return this.path;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public List<String> getBaseUris() {
        return this.baseUris;
    }

    public List<APIParameterModel> getUriParamsModel() {
        return this.uriParamsModel;
    }

    public List<APIParameterModel> getQueryParamsModel() {
        return this.queryParamsModel;
    }

    public List<APIParameterModel> getHeadersModel() {
        return this.headersModel;
    }

    public List<APITypeModel> getInputMetadataModel() {
        return this.inputMetadataModel;
    }

    public List<APITypeModel> getOutputMetadataModel() {
        return this.outputMetadataModel;
    }

    public List<APISecuritySchemeModel> getSecuritySchemesModel() {
        return this.securitySchemesModel;
    }

    public APIDocumentationModel getAPIDocumentationModel() {
        return this.apiDocumentationModel;
    }

    protected <T> List<T> selectSecurityRequirements(List<T> operationSchemes, List<T> endPointSchemes, List<T> globalSchemes) {
        if (!operationSchemes.isEmpty()) {
            return operationSchemes;
        }
        if (!endPointSchemes.isEmpty()) {
            return endPointSchemes;
        }
        if (!globalSchemes.isEmpty()) {
            return globalSchemes;
        }
        return new ArrayList();
    }

    public Optional<APIParameterModel> getParameter(APIParameterType apiParameterType, String name) {
        List<APIParameterModel> parameterList;
        switch (apiParameterType) {
            case HEADER: {
                parameterList = this.getHeadersModel();
                break;
            }
            case QUERY: {
                parameterList = this.getQueryParamsModel();
                break;
            }
            case URI: {
                parameterList = this.getUriParamsModel();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return parameterList.stream().filter(p -> apiParameterType.areNamesEqual(p.getExternalName(), name)).findFirst();
    }

    public abstract APILocation getLocation();
}

