/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APITypeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(APITypeModel.class);
    protected APIType apiType;
    protected MediaType mediaType;
    protected String example;
    protected List<String> enumValues;
    protected APITypeSchemaModel APITypeSchemaModel;
    protected APIPrimitiveType primitiveType;
    protected List<APIParameterModel> parts;
    protected APITypeModel innerType;
    protected List<APITypeModel> unionTypes;
    protected String displayName;
    protected String description;
    protected Boolean required;

    protected APITypeModel() {
    }

    protected APITypeModel(APIPrimitiveType primitiveType) {
        this.apiType = APIType.PRIMITIVE;
        this.primitiveType = primitiveType;
    }

    protected MediaType getMediaTypeForStringOrNull(String mediaType) {
        try {
            return StringUtils.isNotBlank((CharSequence)mediaType) ? MediaType.valueOf((String)mediaType) : null;
        }
        catch (Exception e) {
            LOGGER.error("Error getting media type", (Throwable)e);
            return null;
        }
    }

    public APIType getApiType() {
        return this.apiType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getExample() {
        return this.example;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public APITypeSchemaModel getAPITypeSchemaModel() {
        return this.APITypeSchemaModel;
    }

    public APIPrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public List<APIParameterModel> getParts() {
        return this.parts;
    }

    public APITypeModel getInnerType() {
        return this.innerType;
    }

    public List<APITypeModel> getUnionTypes() {
        return this.unionTypes;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public abstract Map<String, APITypeModel> getObjectProperties();

    public abstract APILocation getLocation();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getApiType().toString());
        switch (this.getApiType()) {
            case OBJECT_TYPE: {
                stringBuilder.append(this.getObjectProperties());
                break;
            }
            case ARRAY: {
                stringBuilder.append("[").append(this.getInnerType()).append(']');
            }
        }
        return stringBuilder.toString();
    }

    public void accept(Visitor visitor) {
        this.accept(visitor, "");
    }

    private void accept(Visitor visitor, String path) {
        visitor.visit(this, path);
        switch (this.getApiType()) {
            case OBJECT_TYPE: {
                this.getObjectProperties().forEach((propertyName, propertyType) -> propertyType.accept(visitor, path.isEmpty() ? propertyName : path + '.' + propertyName));
                break;
            }
            case ARRAY: {
                APITypeModel innerType = this.getInnerType();
                if (innerType == null) break;
                innerType.accept(visitor, path);
            }
        }
    }

    public static abstract class Visitor {
        public abstract void visit(APITypeModel var1, String var2);
    }
}

