/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.WebAPIConfiguration;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.apicontract.client.scala.UnrecognizedSpecException;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.ClasspathResourceLoader;
import amf.core.client.platform.resource.FileResourceLoader;
import amf.core.client.platform.resource.HttpResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.internal.remote.Spec;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.InvalidSourceException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFAPIModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mulesoft.common.client.lexical.PositionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFAPIModelFactory {
    public static final String AMF_VIOLATION_LEVEL = "VIOLATION";
    private static final Logger LOGGER = LoggerFactory.getLogger(AMFAPIModelFactory.class);
    private static final byte[] RAML_FILE_START = "#%RAML 0.8".getBytes(StandardCharsets.UTF_8);
    private final AMFBaseUnitClient baseUnitClient;

    public AMFAPIModelFactory() {
        this(Collections.emptyList());
    }

    public AMFAPIModelFactory(List<String> dialectUrls) {
        AMFConfiguration amfWebApiConfig = WebAPIConfiguration.WebAPI();
        amfWebApiConfig = AMFAPIModelFactory.configureResourceLoaders(amfWebApiConfig);
        amfWebApiConfig = AMFAPIModelFactory.configureDialects(amfWebApiConfig, dialectUrls);
        this.baseUnitClient = amfWebApiConfig.baseUnitClient();
    }

    public AMFAPIModel build(Path apiSpecPath, boolean skipValidations) throws ModelGenerationException {
        return AMFAPIModelFactory.build(this.getWebApi(apiSpecPath, skipValidations));
    }

    public AMFAPIModel build(String apiSpec, boolean skipValidations) throws ModelGenerationException {
        return AMFAPIModelFactory.build(this.getWebApi(apiSpec, skipValidations));
    }

    private static AMFAPIModel build(ParseResult parseResult) throws ModelGenerationException {
        return new AMFAPIModel(parseResult.webApi, parseResult.isRaml);
    }

    private static AMFConfiguration configureResourceLoaders(AMFConfiguration amfConfiguration) {
        return amfConfiguration.withResourceLoaders(Arrays.asList(new FileResourceLoader(), new HttpResourceLoader(), new ClasspathResourceLoader()));
    }

    private static AMFConfiguration configureDialects(AMFConfiguration amfConfiguration, List<String> dialectUrls) {
        for (String dialectUrl : dialectUrls) {
            try {
                amfConfiguration = (AMFConfiguration)amfConfiguration.withDialect(dialectUrl).get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Could not register dialect '" + dialectUrl + "': " + e.getCause(), e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Could not register dialect '" + dialectUrl + "': " + e, e);
            }
        }
        return amfConfiguration;
    }

    private ParseResult getWebApi(Path path, boolean skipValidations) throws InvalidSourceException {
        if (Files.notExists(path, new LinkOption[0])) {
            throw new InvalidSourceException(String.format("Spec file [%s] does not exist", path.toAbsolutePath()));
        }
        if (AMFAPIModelFactory.isRaml08(path)) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        try {
            return this.getWebApi((AMFParseResult)this.baseUnitClient.parse("file://" + path.toAbsolutePath()).get(), skipValidations);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage(), e);
        }
        catch (UnrecognizedSpecException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage() + ". Supported encoding: UTF-8.", (Exception)((Object)e));
        }
    }

    private ParseResult getWebApi(String content, boolean skipValidations) throws InvalidSourceException {
        try {
            return this.getWebApi((AMFParseResult)this.baseUnitClient.parseContent(content).get(), skipValidations);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage(), e);
        }
        catch (UnrecognizedSpecException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage() + ". Supported encoding: UTF-8.", (Exception)((Object)e));
        }
    }

    private ParseResult getWebApi(AMFParseResult amfParseResult, boolean skipValidations) throws InvalidSourceException {
        boolean isRaml = amfParseResult.sourceSpec() != null && amfParseResult.sourceSpec().isRaml();
        AMFConfiguration specificConfiguration = WebAPIConfiguration.fromSpec((Spec)amfParseResult.sourceSpec());
        if (!amfParseResult.conforms()) {
            throw new InvalidSourceException("The provided API specification has errors.\n" + amfParseResult.results().stream().map(AMFAPIModelFactory::validationResultMessage).collect(Collectors.joining(System.lineSeparator())));
        }
        AMFBaseUnitClient specBaseUnitClient = specificConfiguration.baseUnitClient();
        BaseUnit baseUnit = specBaseUnitClient.transform(amfParseResult.baseUnit()).baseUnit();
        if (!(baseUnit instanceof Document)) {
            throw new InvalidSourceException("Document type not supported: " + baseUnit.getClass());
        }
        Document document = (Document)baseUnit;
        if (!skipValidations) {
            this.validateDocument(specBaseUnitClient, document);
        }
        return new ParseResult((WebApi)document.encodes(), isRaml);
    }

    private static String validationResultMessage(AMFValidationResult amfValidationResult) {
        return amfValidationResult.message().replace("\n", "\\n") + amfValidationResult.location().map(loc -> {
            PositionRange position = amfValidationResult.position();
            return ", at " + loc + ':' + position.start() + ' ' + position.end();
        }).orElse("");
    }

    private void validateDocument(AMFBaseUnitClient client, Document document) throws InvalidSourceException {
        AMFValidationReport report;
        try {
            report = (AMFValidationReport)client.validate((BaseUnit)document).get();
        }
        catch (Exception e) {
            String message = String.format("Error validating the spec [%s], detail: %s.", document.location(), e.getMessage());
            throw new InvalidSourceException(message);
        }
        if (!report.conforms()) {
            AMFAPIModelFactory.printErrors(report);
            String errorMessage = String.format("The API spec [%s] is invalid, please fix it (or ignore it).", document.location());
            throw new InvalidSourceException(errorMessage);
        }
    }

    private static void printErrors(AMFValidationReport report) {
        for (AMFValidationResult result : report.results()) {
            if (!result.severityLevel().equalsIgnoreCase(AMF_VIOLATION_LEVEL)) continue;
            LOGGER.error(report.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRaml08(Path specPath) throws InvalidSourceException {
        try (InputStream i = Files.newInputStream(specPath, new OpenOption[0]);){
            byte[] buf = new byte[RAML_FILE_START.length];
            boolean bl = i.read(buf) == RAML_FILE_START.length && Arrays.equals(buf, RAML_FILE_START);
            return bl;
        }
        catch (IOException e) {
            throw new InvalidSourceException("Could not check whether API spec [" + specPath + "] is a RAML file: " + e, e);
        }
    }

    private static class ParseResult {
        final WebApi webApi;
        final boolean isRaml;

        private ParseResult(WebApi webApi, boolean isRaml) {
            this.webApi = webApi;
            this.isRaml = isRaml;
        }
    }
}

