/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveTypeModel;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;

import java.util.HashMap;
import java.util.Map;

public class AMFPrimitiveTypeModel extends APIPrimitiveTypeModel {

  public AMFPrimitiveTypeModel(Shape shape) {
    this.primitiveType = getPrimitiveType(shape);
  }

  public AMFPrimitiveTypeModel(APIPrimitiveType primitiveTypeDefinition) {
    this.primitiveType = primitiveTypeDefinition;
  }

  private static final Map<String, APIPrimitiveType> scalarTypeMappings = new HashMap<>();
  static {
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#boolean", APIPrimitiveType.BOOLEAN);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#float", APIPrimitiveType.NUMBER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#double", APIPrimitiveType.NUMBER);
    scalarTypeMappings.put("http://a.ml/vocabularies/shapes#number", APIPrimitiveType.NUMBER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#integer", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#long", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#byte", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#short", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedByte", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedInt", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedLong", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedShort", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#positiveInteger", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#negativeInteger", APIPrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#string", APIPrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#base64Binary", APIPrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#hexBinary", APIPrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#token", APIPrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#dateTime", APIPrimitiveType.DATE_TIME);
    scalarTypeMappings.put("http://a.ml/vocabularies/shapes#dateTimeOnly", APIPrimitiveType.DATE_TIME_ONLY);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#date", APIPrimitiveType.DATE_ONLY);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#time", APIPrimitiveType.TIME_ONLY);
  }

  private APIPrimitiveType getPrimitiveType(Shape shape) {

    if (shape instanceof ScalarShape) {
      return scalarTypeMappings.get(((ScalarShape) shape).dataType().value());
    }

    else if (shape instanceof FileShape) {
      return APIPrimitiveType.FILE;
    }

    // Reaching this line would mean that a new type is supported in AMF but we have not implemented it in Rest SDK yet
    throw new IllegalArgumentException("Type declaration is not a primitive type.");
  }
}
