/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.util;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.EntityArrays;

public class XmlUtils {
    private XmlUtils() {
    }

    public static boolean isXmlSchema(String schema) {
        return StringUtils.isNotBlank((CharSequence)schema) && schema.trim().startsWith("<");
    }

    public static String removeMavenArtifactUnwantedCharacters(String artifact) {
        if (artifact == null) {
            return null;
        }
        return artifact.replaceAll("[^a-zA-Z0-9_\\-]", "");
    }

    public static String removeMavenGroupUnwantedCharacters(String group) {
        if (group == null) {
            return null;
        }
        return group.replaceAll("[^a-zA-Z0-9\\._\\-]", "");
    }

    public static String removeMavenVersionUnwantedCharacters(String version) {
        if (version == null) {
            return null;
        }
        return version.replaceAll("[^a-zA-Z0-9\\._\\-]", "");
    }

    private static String splitCapsWithHypens(String name) {
        return ParserUtils.splitCaps(name, "-");
    }

    private static String removeXmlNameUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        name = StringUtils.stripAccents((String)name);
        StringBuilder sanitizedBuilder = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() >= 'a' && c.charValue() <= 'z' || c.charValue() >= 'A' && c.charValue() <= 'Z' || c.charValue() >= '0' && c.charValue() <= '9' || c.charValue() == '_' || c.charValue() == '-') {
                sanitizedBuilder.append(c);
                continue;
            }
            String[] sanitization = Arrays.stream(EntityArrays.BASIC_ESCAPE()).filter(x -> x[0].equals(c.toString())).findFirst().orElse(null);
            if (sanitization == null) continue;
            if (sanitizedBuilder.length() > 0 && sanitizedBuilder.charAt(sanitizedBuilder.length() - 1) != '-') {
                sanitizedBuilder.append("-");
            }
            sanitizedBuilder.append(sanitization[1], 1, sanitization[1].length() - 1);
            sanitizedBuilder.append("-");
        }
        return sanitizedBuilder.toString();
    }

    public static String getXmlName(@NotNull String name) {
        name = XmlUtils.splitCapsWithHypens(name).toLowerCase();
        while (name.matches(".*[a-zA-Z0-9]+[\\s]+[a-zA-Z0-9]+.*")) {
            name = name.replaceAll("([a-zA-Z0-9])[\\s]+([a-zA-Z0-9])", "$1-$2");
        }
        name = XmlUtils.removeXmlNameUnwantedCharacters(name);
        if (StringUtils.isEmpty((CharSequence)(name = name.replaceAll("_+", "-")))) {
            return "";
        }
        if (name.toLowerCase().startsWith("xml") || Character.isDigit(name.charAt(0))) {
            name = "_" + name;
        }
        if (name.startsWith("-")) {
            name = name.substring(1);
        }
        if (name.endsWith("-")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

