/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.security.ApiKeySettings;
import amf.apicontract.client.platform.model.domain.security.HttpSettings;
import amf.apicontract.client.platform.model.domain.security.OAuth2Flow;
import amf.apicontract.client.platform.model.domain.security.OAuth2Settings;
import amf.apicontract.client.platform.model.domain.security.SecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security.AMFOauth2FlowsNaming;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security.AMFSecuritySchemesNaming;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AMFSecuritySchemeModel
extends APISecuritySchemeModel {
    private final OAuth2Flow oAuth2Flow;

    public AMFSecuritySchemeModel(SecurityScheme securityScheme) {
        this(securityScheme, null);
    }

    public AMFSecuritySchemeModel(List<SecurityScheme> securitySchemas) {
        this.oAuth2Flow = null;
        this.initModel();
        for (SecurityScheme securityScheme : securitySchemas) {
            this.loadModel(securityScheme);
        }
    }

    public AMFSecuritySchemeModel(SecurityScheme securityScheme, OAuth2Flow oAuth2Flow) {
        this.oAuth2Flow = oAuth2Flow;
        this.initModel();
        this.loadModel(securityScheme);
    }

    private void initModel() {
        this.customHeaders = new ArrayList();
        this.customQueryParams = new ArrayList();
    }

    private void loadModel(SecurityScheme securityScheme) {
        this.name = this.buildName(securityScheme);
        this.securitySchemeType = this.buildSecuritySchemeClass(securityScheme);
        this.customHeaders.addAll(this.buildCustomHeadersModel(securityScheme));
        this.customQueryParams.addAll(this.buildCustomQueryParamsModel(securityScheme));
        this.accessTokenUri = this.buildAccessTokenUri();
        this.authorizationUri = this.buildAuthorizationUri();
        this.scopes = this.buildScopes();
    }

    private String buildName(SecurityScheme securityScheme) {
        String partialName = securityScheme.name().value();
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            return partialName;
        }
        return this.name.concat("-" + partialName);
    }

    private String buildAccessTokenUri() {
        if (this.oAuth2Flow != null) {
            return this.oAuth2Flow.accessTokenUri().value();
        }
        return null;
    }

    private String buildAuthorizationUri() {
        if (this.oAuth2Flow != null) {
            return this.oAuth2Flow.authorizationUri().value();
        }
        return null;
    }

    private List<String> buildScopes() {
        if (this.oAuth2Flow != null) {
            return this.oAuth2Flow.scopes().stream().map(x -> x.name().value()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private APISecuritySchemeType buildSecuritySchemeClass(SecurityScheme securityScheme) {
        String schemeType = securityScheme.type().value();
        if (AMFSecuritySchemesNaming.isBasicAuth(schemeType, this.getHttpSettingsScheme(securityScheme))) {
            return APISecuritySchemeType.BASIC_AUTH;
        }
        if (AMFSecuritySchemesNaming.isPassThrough(schemeType)) {
            return APISecuritySchemeType.PASS_THROUGH;
        }
        if (AMFSecuritySchemesNaming.isApiKey(schemeType)) {
            return APISecuritySchemeType.PASS_THROUGH;
        }
        if (AMFSecuritySchemesNaming.isOauth2(schemeType)) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)securityScheme.settings();
            if (AMFOauth2FlowsNaming.isAuthorizationCode(oAuth2Settings, this.oAuth2Flow)) {
                return APISecuritySchemeType.OAUTH2_AUTHORIZATION_CODE;
            }
            if (AMFOauth2FlowsNaming.isClientCredentials(oAuth2Settings, this.oAuth2Flow)) {
                return APISecuritySchemeType.OAUTH2_CLIENT_CREDENTIALS;
            }
        } else {
            if (AMFSecuritySchemesNaming.isDigest(schemeType)) {
                return APISecuritySchemeType.DIGEST;
            }
            if (AMFSecuritySchemesNaming.isBearer(schemeType, this.getHttpSettingsScheme(securityScheme))) {
                return APISecuritySchemeType.BEARER_AUTH;
            }
            if (AMFSecuritySchemesNaming.isCustom(schemeType)) {
                return APISecuritySchemeType.CUSTOM;
            }
        }
        return APISecuritySchemeType.NOT_SUPPORTED;
    }

    private String getHttpSettingsScheme(SecurityScheme securityScheme) {
        String httpScheme = null;
        if (securityScheme.settings() instanceof HttpSettings) {
            httpScheme = ((HttpSettings)securityScheme.settings()).scheme().value();
        }
        return httpScheme;
    }

    private List<APIParameterModel> buildCustomQueryParamsModel(SecurityScheme securityScheme) {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        for (Parameter x : securityScheme.queryParameters()) {
            AMFParameterModel parameterModel = new AMFParameterModel(x, APIParameterType.QUERY, false);
            list.add(parameterModel);
        }
        AMFParameterModel queryParam = this.getApiKeyParameter("query", securityScheme);
        if (queryParam != null) {
            list.add(queryParam);
        }
        return list;
    }

    private List<APIParameterModel> buildCustomHeadersModel(SecurityScheme securityScheme) {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        for (Parameter x : securityScheme.headers()) {
            AMFParameterModel parameterModel = new AMFParameterModel(x, APIParameterType.HEADER, false);
            list.add(parameterModel);
        }
        AMFParameterModel header = this.getApiKeyParameter("header", securityScheme);
        if (header != null) {
            list.add(header);
        }
        return list;
    }

    private AMFParameterModel getApiKeyParameter(String from, SecurityScheme securityScheme) {
        if (securityScheme.settings() instanceof ApiKeySettings) {
            String in = ((ApiKeySettings)securityScheme.settings()).in().value();
            String name = ((ApiKeySettings)securityScheme.settings()).name().value();
            String string = name = StringUtils.isNotBlank((CharSequence)name) ? name : "api-key";
            if (in.equalsIgnoreCase(from)) {
                return new AMFParameterModel(name, APIParameterType.SECURITY, new AMFPrimitiveTypeModel(APIPrimitiveType.STRING));
            }
        }
        return null;
    }
}

