/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.client.model.StrField;
import amf.client.model.domain.AnyShape;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.OAuth2Flow;
import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.ParametrizedSecurityScheme;
import amf.client.model.domain.Payload;
import amf.client.model.domain.Response;
import amf.client.model.domain.SecurityRequirement;
import amf.client.model.domain.SecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.UnsupportedSecuritySchemeException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFSecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security.AMFSecuritySchemesNaming;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AMFOperationModel
extends APIOperationModel {
    private final EndPoint endPoint;
    private final Operation operation;

    public AMFOperationModel(EndPoint endPoint, Operation operation) throws ModelGenerationException {
        this.endPoint = endPoint;
        this.operation = operation;
        this.description = this.buildOperationDescription();
        this.summary = operation.summary().value();
        this.path = this.buildOperationPath();
        this.httpMethod = operation.method().value();
        this.name = this.buildName();
        this.operationId = operation.operationId().value();
        this.uriParamsModel = this.buildUriParamsModel();
        this.queryParamsModel = this.buildQueryParamsModel();
        this.headersModel = this.buildHeadersModel();
        this.inputMetadataModel = this.buildInputMetadataModels();
        this.outputMetadataModel = this.buildOutputMetadataModels();
        this.securitySchemesModel = this.buildSecuritySchemesModel();
    }

    private List<APISecuritySchemeModel> buildSecuritySchemesModel() throws ModelGenerationException {
        List endPointSchemes = this.endPoint.security().stream().flatMap(AMFOperationModel::getSchemes).filter(Objects::nonNull).collect(Collectors.toList());
        List operationSchemes = this.operation.security().stream().flatMap(AMFOperationModel::getSchemes).filter(Objects::nonNull).collect(Collectors.toList());
        List selectedSchemes = this.selectSecuritySchemes(operationSchemes, endPointSchemes, new ArrayList());
        ArrayList<APISecuritySchemeModel> securitySchemesModel = new ArrayList<APISecuritySchemeModel>();
        for (SecurityScheme securityScheme : selectedSchemes) {
            if (AMFSecuritySchemesNaming.isOauth2(securityScheme.type().value())) {
                securitySchemesModel.addAll(((OAuth2Settings)securityScheme.settings()).flows().stream().map(x -> new AMFSecuritySchemeModel(securityScheme, (OAuth2Flow)x)).collect(Collectors.toList()));
                continue;
            }
            securitySchemesModel.add(new AMFSecuritySchemeModel(securityScheme));
        }
        if (!selectedSchemes.isEmpty() && securitySchemesModel.isEmpty()) {
            throw new UnsupportedSecuritySchemeException(this.httpMethod + " " + this.path + ": None of the specified security schemes are supported.");
        }
        return securitySchemesModel;
    }

    private static Stream<SecurityScheme> getSchemes(DomainElement domainElement) {
        if (domainElement instanceof SecurityRequirement) {
            SecurityRequirement securityRequirement = (SecurityRequirement)domainElement;
            return securityRequirement.schemes().stream().map(ParametrizedSecurityScheme::scheme);
        }
        return Stream.empty();
    }

    private List<APITypeModel> buildOutputMetadataModels() {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        ArrayList<APITypeModel> defaultModel = new ArrayList<APITypeModel>();
        if (this.operation.responses() != null) {
            for (Response response : this.operation.responses()) {
                if (!response.statusCode().nonEmpty()) continue;
                if (response.statusCode().value().startsWith("2")) {
                    models.addAll(this.buildAMFTypeModel(response));
                    continue;
                }
                if (!response.statusCode().value().startsWith("default")) continue;
                defaultModel.addAll(this.buildAMFTypeModel(response));
            }
        }
        if (models.isEmpty()) {
            return defaultModel;
        }
        return models;
    }

    private List<APITypeModel> buildAMFTypeModel(Response response) {
        return this.buildIOMetadataModels(response.payloads(), this.operation.contentType());
    }

    private List<APITypeModel> buildInputMetadataModels() {
        if (this.operation.request() != null) {
            return this.buildIOMetadataModels(this.operation.request().payloads(), this.operation.accepts());
        }
        return Collections.emptyList();
    }

    private List<APITypeModel> buildIOMetadataModels(List<Payload> payloads, List<StrField> globalMediaTypes) {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        if (payloads == null) {
            return models;
        }
        List<String> globalMediaTypesString = globalMediaTypes.stream().map(StrField::value).collect(Collectors.toList());
        for (Payload payload : payloads) {
            if (payload.schema() == null) continue;
            if (payload.mediaType().isNullOrEmpty() && !globalMediaTypesString.isEmpty()) {
                globalMediaTypesString.forEach(x -> models.add(new AMFTypeModel((AnyShape)payload.schema(), (String)x)));
                continue;
            }
            models.add(new AMFTypeModel((AnyShape)payload.schema(), payload.mediaType().value()));
        }
        return models;
    }

    private String buildName() {
        if (this.operation.name().nonEmpty() && StringUtils.isNotBlank((CharSequence)this.operation.name().value()) && !this.operation.name().value().equalsIgnoreCase(this.operation.method().value()) && !this.operation.name().value().equalsIgnoreCase(this.operation.operationId().value())) {
            return this.operation.name().value();
        }
        return null;
    }

    private String buildOperationPath() {
        return this.endPoint.path().value();
    }

    private String buildOperationDescription() {
        return this.operation.description().nonEmpty() ? this.operation.description().value() : this.endPoint.description().value();
    }

    private List<APIParameterModel> buildUriParamsModel() {
        AMFParameterModel parameterModel;
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().uriParameters()) {
                parameterModel = new AMFParameterModel(x, APIParameterType.URI, false);
                list.add(parameterModel);
            }
        }
        for (Parameter x : this.endPoint.parameters()) {
            parameterModel = new AMFParameterModel(x, APIParameterType.URI, false);
            list.add(parameterModel);
        }
        return list;
    }

    private List<APIParameterModel> buildQueryParamsModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().queryParameters()) {
                AMFParameterModel parameterModel = new AMFParameterModel(x, APIParameterType.QUERY, false);
                list.add(parameterModel);
            }
        }
        return list;
    }

    private List<APIParameterModel> buildHeadersModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().headers()) {
                AMFParameterModel parameterModel = new AMFParameterModel(x, APIParameterType.HEADER, false);
                list.add(parameterModel);
            }
        }
        return list;
    }
}

