/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.Payload;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.SchemaShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;

public class AMFParameterModel
extends APIParameterModel {
    public AMFParameterModel(Parameter parameter, APIParameterType parameterType, boolean isPassword) {
        this.externalName = parameter.parameterName().value();
        this.displayName = this.buildDisplayName(parameter);
        this.parameterType = parameterType;
        this.defaultValue = this.buildDefaultValue(parameter);
        this.description = this.buildDescription(parameter);
        this.isPassword = isPassword;
        this.isRequired = parameter.required().value();
        Shape parameterShape = AMFParameterModel.getParameterShape(parameter);
        this.typeModel = new AMFTypeModel((AnyShape)parameterShape, this.getDefaultMediaType(parameterShape));
    }

    private String buildDisplayName(Parameter parameter) {
        Shape parameterShape = AMFParameterModel.getParameterShape(parameter);
        String displayName = parameterShape.displayName().isNullOrEmpty() ? null : ParserUtils.removeHtmlTags(parameterShape.displayName().value());
        return displayName;
    }

    private String buildDescription(Parameter parameter) {
        return parameter.description().value();
    }

    public AMFParameterModel(PropertyShape propertyShape, APIParameterType parameterType) {
        this.externalName = propertyShape.id().substring(propertyShape.id().lastIndexOf(47) + 1);
        this.displayName = propertyShape.displayName().nonEmpty() ? propertyShape.displayName().value() : (propertyShape.range().displayName().nonEmpty() ? propertyShape.range().displayName().value() : null);
        this.description = propertyShape.description().nonEmpty() ? propertyShape.description().value() : propertyShape.range().description().value();
        this.parameterType = parameterType;
        this.typeModel = new AMFTypeModel((AnyShape)propertyShape.range(), this.getDefaultMediaType(propertyShape.range()));
    }

    public AMFParameterModel(String name, APIParameterType parameterType, AMFPrimitiveTypeModel amfPrimitiveTypeParser) {
        this.externalName = name;
        this.displayName = null;
        this.parameterType = parameterType;
        this.typeModel = new AMFTypeModel(amfPrimitiveTypeParser);
    }

    private String buildDefaultValue(Parameter parameter) {
        Shape parameterShape = AMFParameterModel.getParameterShape(parameter);
        return parameterShape.defaultValueStr().nonEmpty() ? parameterShape.defaultValueStr().value() : "";
    }

    private String getDefaultMediaType(Shape shape) {
        if (shape instanceof FileShape) {
            return "application/octet-stream";
        }
        if (shape instanceof NodeShape || shape instanceof ArrayShape || shape instanceof UnionShape) {
            return "application/json";
        }
        if (shape instanceof SchemaShape) {
            if (this.isXmlSchemaShape(shape)) {
                return "application/xml";
            }
            return "application/json";
        }
        return "text/plain";
    }

    private boolean isXmlSchemaShape(Shape shape) {
        if (!(shape instanceof SchemaShape)) {
            return false;
        }
        SchemaShape schemaShape = (SchemaShape)shape;
        return schemaShape.raw().nonEmpty() && XmlUtils.isXmlSchema(schemaShape.raw().value());
    }

    private static Shape getParameterShape(Parameter parameter) {
        Shape shape = parameter.schema();
        if (shape == null && parameter.payloads().size() > 0) {
            shape = parameter.payloads().stream().filter(x -> x.schema() != null).map(Payload::schema).findFirst().orElse(null);
        }
        return shape;
    }
}

