/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import static org.apache.commons.lang3.StringUtils.EMPTY;

import java.util.ArrayList;
import java.util.List;

public abstract class APIModel {

  protected String apiName = EMPTY;
  protected String description = EMPTY;
  protected String baseUri;
  protected String apiVersion;
  protected List<APIOperationModel> operationsModel = new ArrayList<>();
  protected List<String> protocols;

  public String getApiName() {
    return apiName;
  }

  public String getDescription() {
    return description;
  }

  public List<String> getProtocols() {
    return protocols;
  }

  public String getBaseUri() {
    return baseUri;
  }

  public String getApiVersion() {
    return apiVersion;
  }

  public List<APIOperationModel> getOperationsModel() {
    return operationsModel;
  }
}
