/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.OASConfiguration;
import amf.apicontract.client.platform.RAMLConfiguration;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.FileResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.InvalidSourceException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.resourceloader.AMFExchangeDependencyResourceLoader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFAPIModel
extends APIModel {
    public static final String AMF_VIOLATION_LEVEL = "VIOLATION";
    private static final Logger LOGGER = LoggerFactory.getLogger(AMFAPIModel.class);
    private final SpecFormat specFormat;
    private final WebApi webApi;

    public AMFAPIModel(File apiSpec, String rootDir, SpecFormat specFormat, boolean skipValidations) throws ModelGenerationException {
        this.specFormat = specFormat;
        AMFConfiguration configuration = AMFAPIModel.getAMFConfiguration(specFormat, rootDir);
        this.webApi = this.getWebApi(configuration.baseUnitClient(), apiSpec.toPath(), skipValidations);
        this.apiName = this.buildApiName();
        this.description = this.buildDescription();
        this.protocols = this.buildProtocols();
        this.apiVersion = this.buildApiVersion();
        this.baseUri = this.buildBaseUri();
        this.operationsModel = this.buildOperationsModel();
    }

    private String buildApiName() {
        return this.webApi.name().value();
    }

    private String buildDescription() {
        return this.webApi.description().nonEmpty() ? this.webApi.description().value() : "";
    }

    private String buildApiVersion() {
        return this.webApi.version() != null ? this.webApi.version().value() : null;
    }

    private String buildBaseUri() {
        String baseUri = null;
        Server server = this.webApi.servers().stream().filter(x -> x.url().nonEmpty()).findFirst().orElse(null);
        if (server != null) {
            baseUri = server.url().value();
        }
        return baseUri;
    }

    private List<String> buildProtocols() {
        return this.webApi.schemes().stream().map(StrField::value).collect(Collectors.toList());
    }

    private List<APIOperationModel> buildOperationsModel() throws ModelGenerationException {
        ArrayList<APIOperationModel> operationsModel = new ArrayList<APIOperationModel>();
        for (EndPoint endPoint : this.webApi.endPoints()) {
            for (Operation operation : endPoint.operations()) {
                operationsModel.add(new AMFOperationModel(endPoint, operation));
            }
        }
        return operationsModel;
    }

    private static AMFConfiguration getAMFConfiguration(SpecFormat format, String rootDir) {
        AMFConfiguration amfConfiguration;
        if (format.equals((Object)SpecFormat.RAML)) {
            amfConfiguration = RAMLConfiguration.RAML10();
        } else if (format.equals((Object)SpecFormat.JSON_OAS) || format.equals((Object)SpecFormat.YAML_OAS)) {
            amfConfiguration = OASConfiguration.OAS20();
        } else if (format.equals((Object)SpecFormat.YAML_OAS3) || format.equals((Object)SpecFormat.JSON_OAS3)) {
            amfConfiguration = OASConfiguration.OAS30();
        } else {
            throw new IllegalArgumentException("Spec format " + format.getName() + " not supported");
        }
        return amfConfiguration.withResourceLoaders(Arrays.asList(new AMFExchangeDependencyResourceLoader(rootDir), new FileResourceLoader()));
    }

    public WebApi getWebApi(AMFBaseUnitClient client, Path path, boolean skipValidations) throws InvalidSourceException {
        if (Files.notExists(path, new LinkOption[0])) {
            throw new InvalidSourceException(String.format("Spec file [%s] does not exist", path.toAbsolutePath()));
        }
        if (this.isRaml08(path.toAbsolutePath())) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        Document document = this.getDocument(client, path);
        if (!skipValidations) {
            this.validateDocument(client, document);
        }
        return this.getWebApi(document);
    }

    private Document getDocument(AMFBaseUnitClient client, Path path) throws InvalidSourceException {
        AMFParseResult amfParseResult;
        try {
            amfParseResult = (AMFParseResult)client.parse("file://" + path.toAbsolutePath()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage(), e);
        }
        if (!amfParseResult.conforms()) {
            throw new InvalidSourceException("The provided API specification has errors.\n" + amfParseResult.results().stream().map(AMFValidationResult::message).collect(Collectors.joining(System.lineSeparator())));
        }
        BaseUnit baseUnit = client.transform(amfParseResult.baseUnit()).baseUnit();
        if (baseUnit instanceof Document) {
            return (Document)baseUnit;
        }
        throw new InvalidSourceException("Document type not supported: " + baseUnit.getClass());
    }

    private void validateDocument(AMFBaseUnitClient client, Document document) throws InvalidSourceException {
        AMFValidationReport report;
        try {
            report = (AMFValidationReport)client.validate((BaseUnit)document).get();
        }
        catch (Exception e) {
            String message = String.format("Error validating the spec [%s], detail: %s.", document.location(), e.getMessage());
            throw new InvalidSourceException(message);
        }
        if (!report.conforms()) {
            AMFAPIModel.printErrors(report);
            String errorMessage = String.format("The API spec [%s] is invalid, please fix it (or ignore it).", document.location());
            throw new InvalidSourceException(errorMessage);
        }
    }

    private static void printErrors(AMFValidationReport report) {
        for (AMFValidationResult result : report.results()) {
            if (!result.severityLevel().equalsIgnoreCase(AMF_VIOLATION_LEVEL)) continue;
            LOGGER.error(report.toString());
        }
    }

    private WebApi getWebApi(Document document) {
        return (WebApi)document.encodes();
    }

    private boolean isRaml08(Path specPath) throws InvalidSourceException {
        String content;
        try {
            content = new String(Files.readAllBytes(specPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InvalidSourceException("Could not load raml file content", e);
        }
        return content.startsWith("#%RAML 0.8");
    }
}

