/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.WebAPIConfiguration;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.apicontract.client.scala.UnrecognizedSpecException;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.FileResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.internal.remote.Spec;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.InvalidSourceException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.resourceloader.AMFExchangeDependencyResourceLoader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFAPIModel
extends APIModel {
    public static final String AMF_VIOLATION_LEVEL = "VIOLATION";
    private static final Logger LOGGER = LoggerFactory.getLogger(AMFAPIModel.class);
    private static final AMFConfiguration AMF_WEB_API_CONFIG = WebAPIConfiguration.WebAPI();
    private final WebApi webApi;

    public AMFAPIModel(File apiSpec, String rootDir, boolean skipValidations) throws ModelGenerationException {
        this.webApi = this.getWebApi(apiSpec.toPath(), rootDir, skipValidations);
        this.apiName = this.buildApiName();
        this.description = this.buildDescription();
        this.protocols = this.buildProtocols();
        this.apiVersion = this.buildApiVersion();
        this.baseUri = this.buildBaseUri();
        this.operationsModel = this.buildOperationsModel();
    }

    private String buildApiName() {
        return this.webApi.name().value();
    }

    private String buildDescription() {
        return this.webApi.description().nonEmpty() ? this.webApi.description().value() : "";
    }

    private String buildApiVersion() {
        return this.webApi.version() != null ? this.webApi.version().value() : null;
    }

    private String buildBaseUri() {
        String baseUri = null;
        Server server = this.webApi.servers().stream().filter(x -> x.url().nonEmpty()).findFirst().orElse(null);
        if (server != null) {
            baseUri = server.url().value();
        }
        return baseUri;
    }

    private List<String> buildProtocols() {
        return this.webApi.schemes().stream().map(StrField::value).collect(Collectors.toList());
    }

    private List<APIOperationModel> buildOperationsModel() throws ModelGenerationException {
        ArrayList<APIOperationModel> operationsModel = new ArrayList<APIOperationModel>();
        for (EndPoint endPoint : this.webApi.endPoints()) {
            for (Operation operation : endPoint.operations()) {
                operationsModel.add(new AMFOperationModel(endPoint, operation));
            }
        }
        return operationsModel;
    }

    private static void configureResourceLoaders(AMFConfiguration amfConfiguration, String rootDir) {
        amfConfiguration.withResourceLoaders(Arrays.asList(new AMFExchangeDependencyResourceLoader(rootDir), new FileResourceLoader()));
    }

    public WebApi getWebApi(Path path, String rootDir, boolean skipValidations) throws InvalidSourceException {
        if (Files.notExists(path, new LinkOption[0])) {
            throw new InvalidSourceException(String.format("Spec file [%s] does not exist", path.toAbsolutePath()));
        }
        if (this.isRaml08(path.toAbsolutePath())) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        return this.parseWebApi(path, rootDir, skipValidations);
    }

    private WebApi parseWebApi(Path path, String rootDir, boolean skipValidations) throws InvalidSourceException {
        AMFConfiguration specificConfiguration;
        AMFParseResult amfParseResult;
        try {
            AMFAPIModel.configureResourceLoaders(AMF_WEB_API_CONFIG, rootDir);
            amfParseResult = (AMFParseResult)AMF_WEB_API_CONFIG.baseUnitClient().parse("file://" + path.toAbsolutePath()).get();
            specificConfiguration = WebAPIConfiguration.fromSpec((Spec)amfParseResult.sourceSpec());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage(), e);
        }
        catch (UnrecognizedSpecException e) {
            throw new InvalidSourceException("Error parsing spec: " + e.getMessage() + ". Supported encoding: UTF-8.", (Exception)((Object)e));
        }
        if (!amfParseResult.conforms()) {
            throw new InvalidSourceException("The provided API specification has errors.\n" + amfParseResult.results().stream().map(AMFValidationResult::message).collect(Collectors.joining(System.lineSeparator())));
        }
        AMFBaseUnitClient specBaseUnitClient = specificConfiguration.baseUnitClient();
        BaseUnit baseUnit = specBaseUnitClient.transform(amfParseResult.baseUnit()).baseUnit();
        if (!(baseUnit instanceof Document)) {
            throw new InvalidSourceException("Document type not supported: " + baseUnit.getClass());
        }
        Document document = (Document)baseUnit;
        if (!skipValidations) {
            this.validateDocument(specBaseUnitClient, document);
        }
        return (WebApi)document.encodes();
    }

    private void validateDocument(AMFBaseUnitClient client, Document document) throws InvalidSourceException {
        AMFValidationReport report;
        try {
            report = (AMFValidationReport)client.validate((BaseUnit)document).get();
        }
        catch (Exception e) {
            String message = String.format("Error validating the spec [%s], detail: %s.", document.location(), e.getMessage());
            throw new InvalidSourceException(message);
        }
        if (!report.conforms()) {
            AMFAPIModel.printErrors(report);
            String errorMessage = String.format("The API spec [%s] is invalid, please fix it (or ignore it).", document.location());
            throw new InvalidSourceException(errorMessage);
        }
    }

    private static void printErrors(AMFValidationReport report) {
        for (AMFValidationResult result : report.results()) {
            if (!result.severityLevel().equalsIgnoreCase(AMF_VIOLATION_LEVEL)) continue;
            LOGGER.error(report.toString());
        }
    }

    private boolean isRaml08(Path specPath) throws InvalidSourceException {
        String content;
        try {
            content = new String(Files.readAllBytes(specPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InvalidSourceException("Could not load raml file content", e);
        }
        return content.startsWith("#%RAML 0.8");
    }
}

