/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.core.client.platform.model.domain.DataNode;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.Example;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.SchemaShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeSchemaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;

public class AMFTypeModel
extends APITypeModel {
    private AnyShape shape;

    public AMFTypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
        super(primitiveTypeModel);
    }

    public AMFTypeModel(AnyShape anyShape, String mediaType) {
        this.shape = anyShape;
        this.example = this.buildExample();
        this.enumValues = this.buildEnumValues();
        this.mediaType = this.getMediaTypeForStringOrNull(mediaType);
        this.APITypeSchemaModel = AMFTypeSchemaModel.builder().build(anyShape, this.mediaType);
        this.apiType = this.buildTypeDefinitionClass(this.mediaType);
        this.displayName = this.buildDisplayName();
        this.description = this.buildDescription();
    }

    private String buildDescription() {
        return this.shape.description().isNullOrEmpty() ? null : this.shape.description().value();
    }

    private String buildDisplayName() {
        return this.shape.displayName().isNullOrEmpty() ? null : this.shape.displayName().value();
    }

    private APIType buildTypeDefinitionClass(MediaType mediaType) {
        if (this.shape instanceof ScalarShape || this.shape instanceof FileShape) {
            this.primitiveTypeModel = new AMFPrimitiveTypeModel((Shape)this.shape);
            return APIType.PRIMITIVE;
        }
        if (MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)mediaType) && this.shape instanceof NodeShape && !((NodeShape)this.shape).properties().isEmpty()) {
            return APIType.MULTIPART;
        }
        if (this.shape instanceof NodeShape || this.shape instanceof SchemaShape) {
            return APIType.OBJECT_TYPE;
        }
        if (this.shape instanceof UnionShape) {
            return APIType.UNION_TYPE;
        }
        if (this.shape instanceof ArrayShape) {
            return APIType.ARRAY;
        }
        if (!(this.shape.and().isEmpty() && this.shape.or().isEmpty() && this.shape.xone().isEmpty())) {
            return APIType.OBJECT_TYPE;
        }
        return APIType.EMPTY;
    }

    private String buildExample() {
        return !this.shape.examples().isEmpty() && ((Example)this.shape.examples().get(0)).value().nonEmpty() ? ((Example)this.shape.examples().get(0)).value().value() : null;
    }

    private List<String> buildEnumValues() {
        return !this.shape.values().isEmpty() ? this.shape.values().stream().map(this::getEnumValue).collect(Collectors.toList()) : null;
    }

    @Override
    public List<APIParameterModel> getParts() {
        if (this.apiType.equals((Object)APIType.MULTIPART)) {
            ArrayList<APIParameterModel> parts = new ArrayList<APIParameterModel>();
            for (PropertyShape s : ((NodeShape)this.shape).properties()) {
                parts.add(new AMFParameterModel(s, APIParameterType.PART));
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public APITypeModel getInnerType() {
        if (this.shape instanceof ArrayShape) {
            Shape innerShape = ((ArrayShape)this.shape).items();
            if (innerShape instanceof AnyShape) {
                return new AMFTypeModel((AnyShape)innerShape, null);
            }
            return new AMFTypeModel(new AMFPrimitiveTypeModel(APIPrimitiveType.STRING));
        }
        return null;
    }

    @Override
    public List<APITypeModel> getUnionTypes() {
        if (this.shape instanceof UnionShape) {
            ArrayList<APITypeModel> list = new ArrayList<APITypeModel>();
            for (Shape x : ((UnionShape)this.shape).anyOf()) {
                AMFTypeModel amfTypeParser = new AMFTypeModel((AnyShape)x, null);
                list.add(amfTypeParser);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private String getEnumValue(DataNode x) {
        if (x instanceof ScalarNode) {
            return ((ScalarNode)x).value().value();
        }
        throw new IllegalArgumentException("Enum type not supported");
    }
}

