/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import static amf.shapes.client.platform.ShapesConfiguration.predefined;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;

import java.io.StringWriter;
import java.util.function.Supplier;

import javax.ws.rs.core.MediaType;

import amf.core.client.platform.config.RenderOptions;
import amf.shapes.client.platform.ShapesConfiguration;
import amf.shapes.client.platform.ShapesElementClient;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.xml.internal.transformer.TypeToXmlSchema;
import org.apache.ws.commons.schema.XmlSchema;

public class AMFTypeSchemaSupplier implements Supplier<String> {

  private static final RenderOptions RENDER_OPTIONS = new RenderOptions().withDocumentation().withCompactedEmission();
  private static final ShapesConfiguration JSON_EMITTER_CONFIGURATION = predefined().withRenderOptions(RENDER_OPTIONS);
  private static final ShapesElementClient JSON_EMITTER_CLIENT = JSON_EMITTER_CONFIGURATION.elementClient();

  private final AnyShape shape;
  private final MediaType mediaType;

  AMFTypeSchemaSupplier(AnyShape shape, MediaType mediaType) {
    this.shape = shape;
    this.mediaType = mediaType;
  }

  @Override
  public String get() {
    if (mediaType != null && mediaType.equals(APPLICATION_XML_TYPE)) {
      return buildXmlTypeSchema(shape);
    } else {
      return JSON_EMITTER_CLIENT.buildJsonSchema(shape);
    }
  }

  private String buildXmlTypeSchema(AnyShape anyShape) {
    XmlSchema xmlSchema = TypeToXmlSchema.transform("root", anyShape._internal());
    xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");

    StringWriter schemaWriter = new StringWriter();
    xmlSchema.write(schemaWriter);
    return schemaWriter.toString();
  }
}
