/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.core.client.platform.model.domain.DataNode;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.Example;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.SchemaShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeSchemaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFTypeModel
extends APITypeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMFTypeModel.class);
    private static final List<String> ALLOWED_MEDIA_TYPES_FOR_EXAMPLE = new ArrayList<String>(){
        {
            this.add("application/json");
            this.add("application/xml");
            this.add("application/x-www-form-urlencoded");
            this.add("multipart/form-data");
            this.add("text/csv");
            this.add("text/html");
            this.add("text/plain");
        }
    };
    private AnyShape shape;
    private boolean extractExample;

    public AMFTypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
        super(primitiveTypeModel);
    }

    public AMFTypeModel(AnyShape anyShape, String mediaType, boolean extractExample) {
        this.shape = anyShape;
        this.mediaType = this.getMediaTypeForStringOrNull(mediaType);
        this.extractExample = extractExample;
        if (extractExample) {
            this.example = this.buildResponseExample();
        }
        this.enumValues = this.buildEnumValues();
        this.APITypeSchemaModel = AMFTypeSchemaModel.builder().build(anyShape, this.mediaType);
        this.apiType = this.buildTypeDefinitionClass(this.mediaType);
        this.displayName = this.buildDisplayName();
        this.description = this.buildDescription();
    }

    private String buildDescription() {
        return this.shape.description().isNullOrEmpty() ? null : this.shape.description().value();
    }

    private String buildDisplayName() {
        return this.shape.displayName().isNullOrEmpty() ? null : this.shape.displayName().value();
    }

    private APIType buildTypeDefinitionClass(MediaType mediaType) {
        if (this.shape instanceof ScalarShape || this.shape instanceof FileShape) {
            this.primitiveTypeModel = new AMFPrimitiveTypeModel((Shape)this.shape);
            return APIType.PRIMITIVE;
        }
        if (MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)mediaType) && this.shape instanceof NodeShape && !((NodeShape)this.shape).properties().isEmpty()) {
            return APIType.MULTIPART;
        }
        if (this.shape instanceof NodeShape || this.shape instanceof SchemaShape) {
            return APIType.OBJECT_TYPE;
        }
        if (this.shape instanceof UnionShape) {
            return APIType.UNION_TYPE;
        }
        if (this.shape instanceof ArrayShape) {
            return APIType.ARRAY;
        }
        if (!(this.shape.and().isEmpty() && this.shape.or().isEmpty() && this.shape.xone().isEmpty())) {
            return APIType.OBJECT_TYPE;
        }
        return APIType.EMPTY;
    }

    private String buildResponseExample() {
        if (this.shape.examples().isEmpty() || !this.isResponseMediaTypeValid()) {
            return null;
        }
        return this.getExampleFromResponsePayload().orElse(null);
    }

    private boolean isResponseMediaTypeValid() {
        if (this.mediaType == null) {
            LOGGER.warn(String.format("An exception occurred while extracting and processing sample data example to be auto generated. %s", String.format("A null output media type has been found and is not allowed to auto generate the sample data based on an example. Allowed media types are: %s\"", String.join((CharSequence)",", ALLOWED_MEDIA_TYPES_FOR_EXAMPLE))));
            return false;
        }
        if (ALLOWED_MEDIA_TYPES_FOR_EXAMPLE.stream().noneMatch(x -> x.equals(this.mediaType.toString()))) {
            LOGGER.warn(String.format("An exception occurred while extracting and processing sample data example to be auto generated. %s", String.format("The following type is not allowed to auto generate the sample data based on an example: %s. Allowed media types are: %s", this.mediaType.toString(), String.join((CharSequence)",", ALLOWED_MEDIA_TYPES_FOR_EXAMPLE))));
            return false;
        }
        return true;
    }

    private Optional<String> getExampleFromResponsePayload() {
        String example = null;
        Optional<Example> exampleString = this.shape.examples().stream().filter(x -> this.isYamlExample((Example)x) || this.isRamlExample((Example)x)).findFirst();
        if (exampleString.isPresent()) {
            example = exampleString.get().value().value();
        }
        return Optional.ofNullable(example);
    }

    private boolean isRamlExample(Example example) {
        return example.mediaType().value() == null;
    }

    private boolean isYamlExample(Example example) {
        return example.mediaType().value() != null && example.mediaType().value().equals(this.mediaType.toString());
    }

    private List<String> buildEnumValues() {
        return !this.shape.values().isEmpty() ? this.shape.values().stream().map(this::getEnumValue).collect(Collectors.toList()) : null;
    }

    @Override
    public List<APIParameterModel> getParts() {
        if (this.apiType.equals((Object)APIType.MULTIPART)) {
            ArrayList<APIParameterModel> parts = new ArrayList<APIParameterModel>();
            for (PropertyShape s : ((NodeShape)this.shape).properties()) {
                parts.add(new AMFParameterModel(s, APIParameterType.PART));
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public APITypeModel getInnerType() {
        if (this.shape instanceof ArrayShape) {
            Shape innerShape = ((ArrayShape)this.shape).items();
            if (innerShape instanceof AnyShape) {
                return new AMFTypeModel((AnyShape)innerShape, null, this.extractExample);
            }
            return new AMFTypeModel(new AMFPrimitiveTypeModel(APIPrimitiveType.STRING));
        }
        return null;
    }

    @Override
    public List<APITypeModel> getUnionTypes() {
        if (this.shape instanceof UnionShape) {
            ArrayList<APITypeModel> list = new ArrayList<APITypeModel>();
            for (Shape x : ((UnionShape)this.shape).anyOf()) {
                AMFTypeModel amfTypeParser = new AMFTypeModel((AnyShape)x, null, this.extractExample);
                list.add(amfTypeParser);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private String getEnumValue(DataNode x) {
        if (x instanceof ScalarNode) {
            return ((ScalarNode)x).value().value();
        }
        throw new IllegalArgumentException("Enum type not supported");
    }
}

