/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type;

public enum APIParameterType {

  URI(true), QUERY(true), HEADER(false), SECURITY(false), PART(false);

  private final boolean caseSensitive;

  APIParameterType(boolean caseSensitive) {
    this.caseSensitive = caseSensitive;
  }

  /**
   * Checks whether two parameter names are equal, considering the case sensitivity mandated by this parameter type.
   *
   * @param name1 a name
   * @param name2 another name
   * @return whether they are equal
   */
  @SuppressWarnings("StringEquality")
  public boolean areNamesEqual(String name1, String name2) {
    return name1 == null || name2 == null ? name1 == name2
        : (caseSensitive ? name1.equals(name2) : name1.equalsIgnoreCase(name2));
  }
}
