/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.domain.Graph;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static java.util.stream.Collectors.toList;

public class AMFAPIModel extends APIModel {

  private final WebApi webApi;


  public AMFAPIModel(WebApi webApi, boolean isRaml) throws ModelGenerationException {
    super(buildApiName(webApi), buildDescription(webApi), buildBaseUri(webApi), buildApiVersion(webApi),
          buildOperationsModel(webApi, isRaml), buildProtocols(webApi));
    this.webApi = webApi;
  }

  private static String buildApiName(WebApi webApi) {
    return webApi.name().value();
  }

  private static String buildDescription(WebApi webApi) {
    StrField description = webApi.description();
    return description.nonEmpty() ? description.value() : "";
  }

  private static String buildApiVersion(WebApi webApi) {
    StrField version = webApi.version();
    return version != null ? version.value() : null;
  }

  private static String buildBaseUri(WebApi webApi) {
    return webApi.servers().stream().filter(x -> x.url().nonEmpty()).findFirst().map(server -> server.url().value()).orElse(null);
  }

  private static List<String> buildProtocols(WebApi webApi) {
    return webApi.schemes().stream().map(StrField::value).collect(toList());
  }

  private static List<APIOperationModel> buildOperationsModel(WebApi webApi, boolean isRaml) throws ModelGenerationException {
    List<APIOperationModel> operationsModel = new ArrayList<>();

    for (EndPoint endPoint : webApi.endPoints()) {
      for (amf.apicontract.client.platform.model.domain.Operation operation : endPoint.operations()) {
        operationsModel.add(new AMFOperationModel(endPoint, operation, isRaml));
      }
    }

    return Collections.unmodifiableList(operationsModel);
  }

  @SuppressWarnings("unused")
  public Graph graph() {
    return webApi.graph();
  }

  @Override
  public APILocation getLocation() {
    return APILocation.from(webApi.annotations());
  }
}
