/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.api;

public enum SpecFormat {

  RAML("RAML"), JSON_OAS("JsonOAS"), YAML_OAS("YamlOAS");

  private final String name;

  SpecFormat(String name) {
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public static SpecFormat getFromString(String specName) {
    if (specName.equalsIgnoreCase(RAML.name)) {
      return RAML;
    } else if (specName.equalsIgnoreCase(JSON_OAS.name)) {
      return JSON_OAS;
    } else if (specName.equalsIgnoreCase(YAML_OAS.name)) {
      return YAML_OAS;
    }

    throw new IllegalArgumentException("Spec format " + specName + " does not exist. (RAML, JsonOAS & YamlOAS available)");
  }

}
