/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

public class BaseUriDescriptor extends DescriptorElement {

  private final String value;
  private final String type;
  private final List<MultipleBaseUriDescriptor> mapping;

  public BaseUriDescriptor(String value, String type, List<MultipleBaseUriDescriptor> mapping) {
    this.value = value;
    this.type = type;
    this.mapping = mapping;
  }

  public String getValue() {
    return value;
  }

  public String getType() {
    return type;
  }

  public List<MultipleBaseUriDescriptor> getMapping() {
    return mapping;
  }

}
